/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.bv;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealComparison
extends AbstractExpression<Long>
implements IntegerValue {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(RealComparison.class);
    private final Expression<Double> left;
    private final Expression<Double> right;

    public RealComparison(Expression<Double> left, Expression<Double> right, Long con) {
        super(con, 1 + left.getSize() + right.getSize(), left.containsSymbolicVariable() || right.containsSymbolicVariable());
        this.left = left;
        this.right = right;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RealComparison) {
            RealComparison other = (RealComparison)obj;
            return this.left.equals(other.left) && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode();
    }

    public Expression<Double> getRightOperant() {
        return this.right;
    }

    public Expression<Double> getLeftOperant() {
        return this.left;
    }

    public String toString() {
        return "(" + this.left + " cmp " + this.right + ")";
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.left.getVariables());
        variables.addAll(this.right.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.left.getConstants());
        result.addAll(this.right.getConstants());
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

