/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.fp;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Cast;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;

public final class IntegerToRealCast
extends AbstractExpression<Double>
implements RealValue,
Cast<Long> {
    private static final long serialVersionUID = -3070453617714122236L;
    private final IntegerValue expr;

    public IntegerToRealCast(IntegerValue _expr, Double _concValue) {
        super(_concValue, 1 + _expr.getSize(), _expr.containsSymbolicVariable());
        this.expr = _expr;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Expression<Long> getArgument() {
        return this.expr;
    }

    public String toString() {
        return "((REAL)" + this.expr + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntegerToRealCast) {
            IntegerToRealCast other = (IntegerToRealCast)obj;
            return this.expr.equals(other.expr);
        }
        return false;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.expr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.expr.getConstants();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

