/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.search.IntegerAVM;
import org.evosuite.symbolic.solver.search.RealAVM;
import org.evosuite.symbolic.solver.search.StringAVM;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvoSuiteSolver
extends Solver {
    static Logger log = LoggerFactory.getLogger(EvoSuiteSolver.class);

    @Override
    public Map<String, Object> solve(Collection<Constraint<?>> constraints) throws ConstraintSolverTimeoutException {
        long startTimeMillis = System.currentTimeMillis();
        double distance = DistanceEstimator.getDistance(constraints);
        if (distance == 0.0) {
            log.info("Initial distance already is 0.0, skipping search");
            return null;
        }
        Set<Variable<?>> variables = EvoSuiteSolver.getVariables(constraints);
        Map<String, Object> initialValues = EvoSuiteSolver.getConcreteValues(variables);
        for (int attempt = 0; attempt <= Properties.DSE_VARIABLE_RESETS; ++attempt) {
            for (Variable<?> v : variables) {
                Object avm;
                long currentTimeMillis = System.currentTimeMillis();
                if (Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS > 0L && currentTimeMillis - startTimeMillis > Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS) {
                    throw new ConstraintSolverTimeoutException();
                }
                log.debug("Variable: " + v + ", " + variables);
                if (v instanceof IntegerVariable) {
                    IntegerVariable integerVariable = (IntegerVariable)v;
                    avm = new IntegerAVM(integerVariable, constraints);
                    ((IntegerAVM)avm).applyAVM();
                } else if (v instanceof RealVariable) {
                    RealVariable realVariable = (RealVariable)v;
                    avm = new RealAVM(realVariable, constraints);
                    ((RealAVM)avm).applyAVM();
                } else if (v instanceof StringVariable) {
                    StringVariable strVariable = (StringVariable)v;
                    avm = new StringAVM(strVariable, constraints);
                    ((StringAVM)avm).applyAVM();
                } else {
                    throw new RuntimeException("Unknown variable type " + v.getClass().getName());
                }
                if (!((distance = DistanceEstimator.getDistance(constraints)) <= 0.0)) continue;
                log.info("Distance is 0, ending search");
                break;
            }
            if (distance <= 0.0) {
                log.info("Distance is 0, ending search");
                break;
            }
            log.info("Randomizing variables");
            EvoSuiteSolver.randomizeValues(variables, EvoSuiteSolver.getConstants(constraints));
        }
        if (distance <= 0.0) {
            log.debug("Distance is " + distance + ", found solution");
            Map<String, Object> new_model = EvoSuiteSolver.getConcreteValues(variables);
            EvoSuiteSolver.setConcreteValues(variables, initialValues);
            return new_model;
        }
        EvoSuiteSolver.setConcreteValues(variables, initialValues);
        log.debug("Returning null, search was not successful");
        return null;
    }

    private static void randomizeValues(Set<Variable<?>> variables, Set<Object> constants) {
        HashSet<String> stringConstants = new HashSet<String>();
        HashSet<Long> longConstants = new HashSet<Long>();
        HashSet<Double> realConstants = new HashSet<Double>();
        for (Object object : constants) {
            if (object instanceof String) {
                stringConstants.add((String)object);
                continue;
            }
            if (object instanceof Double) {
                realConstants.add((Double)object);
                continue;
            }
            if (object instanceof Long) {
                longConstants.add((Long)object);
                continue;
            }
            assert (false) : "Unexpected constant type: " + object;
        }
        for (Variable variable : variables) {
            if (variable instanceof StringVariable) {
                StringVariable sv = (StringVariable)variable;
                if (!stringConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                    sv.setConcreteValue((String)Randomness.choice(stringConstants));
                    continue;
                }
                sv.setConcreteValue(Randomness.nextString(Properties.STRING_LENGTH));
                continue;
            }
            if (variable instanceof IntegerVariable) {
                IntegerVariable iv = (IntegerVariable)variable;
                if (!longConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                    iv.setConcreteValue((Long)Randomness.choice(longConstants));
                    continue;
                }
                iv.setConcreteValue((long)Randomness.nextInt(Properties.MAX_INT * 2) - (long)Properties.MAX_INT);
                continue;
            }
            if (!(variable instanceof RealVariable)) continue;
            RealVariable rv = (RealVariable)variable;
            if (!realConstants.isEmpty() && Randomness.nextDouble() < Properties.DSE_CONSTANT_PROBABILITY) {
                rv.setConcreteValue((Double)Randomness.choice(realConstants));
                continue;
            }
            rv.setConcreteValue((long)Randomness.nextInt(Properties.MAX_INT * 2) - (long)Properties.MAX_INT);
        }
    }

    private static Set<Object> getConstants(Collection<Constraint<?>> constraints) {
        HashSet<Object> constants = new HashSet<Object>();
        for (Constraint<?> c : constraints) {
            constants.addAll(c.getConstants());
        }
        return constants;
    }
}

