/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Z3ModelParser {
    private final Map<String, Object> initialValues;
    static Logger logger = LoggerFactory.getLogger(Z3ModelParser.class);

    public Z3ModelParser(Map<String, Object> initialValues) {
        this.initialValues = initialValues;
    }

    public Map<String, Object> parse(String z3ResultStr) {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        HashMap<String, String> arraysToFuncMap = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(z3ResultStr, "() \n\t");
        tokenizer.nextToken();
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            Number value;
            String token = tokenizer.nextToken();
            if (!token.equals("define-fun")) continue;
            String funcName = tokenizer.nextToken();
            if (funcName.equals("str_length")) {
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                continue;
            }
            String typeName = tokenizer.nextToken();
            if (typeName.equals("Int")) {
                String integerValueStr = tokenizer.nextToken();
                if (integerValueStr.equals("-")) {
                    String absoluteIntegerValue = tokenizer.nextToken();
                    value = Long.parseLong("-" + absoluteIntegerValue);
                } else {
                    value = Long.parseLong(integerValueStr);
                }
                solution.put(funcName, value);
                continue;
            }
            if (typeName.equals("Real")) {
                String realValueStr = tokenizer.nextToken();
                if (realValueStr.equals("-")) {
                    String absoluteValueStr = tokenizer.nextToken();
                    if (absoluteValueStr.equals("/")) {
                        String numeratorStr = tokenizer.nextToken();
                        String denominatorStr = tokenizer.nextToken();
                        double numerator = Double.parseDouble(numeratorStr);
                        double denominator = Double.parseDouble(denominatorStr);
                        value = -(numerator / denominator);
                    } else {
                        value = Double.parseDouble("-" + absoluteValueStr);
                    }
                } else if (realValueStr.equals("/")) {
                    String numeratorStr = tokenizer.nextToken();
                    String denominatorStr = tokenizer.nextToken();
                    double numerator = Double.parseDouble(numeratorStr);
                    double denominator = Double.parseDouble(denominatorStr);
                    value = numerator / denominator;
                } else {
                    value = Double.parseDouble(realValueStr);
                }
                solution.put(funcName, value);
                continue;
            }
            if (typeName.equals("Array")) {
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                String arrayFuncName = tokenizer.nextToken();
                arraysToFuncMap.put(arrayFuncName, funcName);
                continue;
            }
            if (!typeName.equals("x!1")) continue;
        }
        if (solution.isEmpty()) {
            logger.warn("The Z3 model has no variables");
        } else {
            logger.debug("Parsed values from Z3 output");
            for (String varName : solution.keySet()) {
                String valueOf = String.valueOf(solution.get(varName));
                logger.debug(varName + ":" + valueOf);
            }
        }
        logger.debug("Adding missing values to Solver solution");
        Z3ModelParser.addMissingValues(this.initialValues, solution);
        return solution;
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

