/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3str;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.z3.Z3Solver;
import org.evosuite.symbolic.solver.z3str.ConstraintToZ3StrVisitor;
import org.evosuite.symbolic.solver.z3str.Z3StrExprBuilder;
import org.evosuite.symbolic.solver.z3str.Z3StrModelParser;
import org.evosuite.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z3StrSolver
extends Solver {
    private static final String EVOSUITE_Z3_STR_FILENAME = "evosuite.z3";
    static Logger logger = LoggerFactory.getLogger(Z3Solver.class);
    private static int dirCounter = 0;

    private static File createNewTmpDir() {
        File dir = null;
        String dirName = FileUtils.getTempDirectoryPath() + File.separator + "EvoSuiteZ3Str_" + dirCounter++ + "_" + System.currentTimeMillis();
        dir = new File(dirName);
        if (!dir.mkdirs()) {
            logger.error("Cannot create tmp dir: " + dirName);
            return null;
        }
        if (!dir.exists()) {
            logger.error("Weird behavior: we created folder, but Java cannot determine if it exists? Folder: " + dirName);
            return null;
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> solve(Collection<Constraint<?>> constraints) throws ConstraintSolverTimeoutException {
        Map<String, Object> map;
        StringBuffer buff = new StringBuffer();
        Set<Variable<?>> variables = Z3StrSolver.getVariables(constraints);
        for (Variable<?> v : variables) {
            String varName = v.getName();
            if (v instanceof IntegerVariable) {
                String intVar = Z3StrExprBuilder.mkIntVariable(varName);
                buff.append(intVar);
                buff.append("\n");
                continue;
            }
            if (v instanceof RealVariable) {
                String realVar = Z3StrExprBuilder.mkRealVariable(varName);
                buff.append(realVar);
                buff.append("\n");
                continue;
            }
            if (v instanceof StringVariable) {
                String stringVar = Z3StrExprBuilder.mkStringVariable(varName);
                buff.append(stringVar);
                buff.append("\n");
                continue;
            }
            throw new RuntimeException("Unknown variable type " + v.getClass().getCanonicalName());
        }
        ConstraintToZ3StrVisitor v = new ConstraintToZ3StrVisitor();
        LinkedList<String> z3StrAssertions = new LinkedList<String>();
        for (Constraint<?> c : constraints) {
            String constraintStr = c.accept(v, null);
            if (constraintStr == null) continue;
            String z3Assert = Z3StrExprBuilder.mkAssert(constraintStr);
            z3StrAssertions.add(z3Assert);
        }
        Set<String> stringConstants = v.getStringConstants();
        for (String string : stringConstants) {
            String encodedStringConstant = Z3StrExprBuilder.encodeString(string);
            String constDecl = Z3StrExprBuilder.mkStringVariable(encodedStringConstant);
            buff.append(constDecl);
            buff.append("\n");
        }
        for (String z3StrAssertion : z3StrAssertions) {
            buff.append(z3StrAssertion);
            buff.append("\n");
        }
        buff.append("(check-sat)");
        buff.append("\n");
        System.out.println("Z3 input:");
        String smtQuery = buff.toString();
        System.out.println(smtQuery);
        int timeout = (int)Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        File tempDir = Z3StrSolver.createNewTmpDir();
        String z3TempFileName = tempDir.getAbsolutePath() + File.separatorChar + EVOSUITE_Z3_STR_FILENAME;
        if (Properties.Z3_STR_PATH == null) {
            logger.error("Property Z3_STR_PATH should be setted in order to use the Z3StrSolver!");
            return null;
        }
        try {
            Utils.writeFile(smtQuery, z3TempFileName);
            String z3Cmd = Properties.Z3_STR_PATH + " -f " + z3TempFileName;
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            Z3StrSolver.launchNewProcess(z3Cmd, smtQuery, timeout, stdout);
            String z3ResultStr = stdout.toString("UTF-8");
            Z3StrModelParser parser = new Z3StrModelParser();
            Map<String, Object> initialValues = Z3StrSolver.getConcreteValues(variables);
            if (z3ResultStr.contains("unknown sort") || z3ResultStr.contains("unknown constant") || z3ResultStr.contains("invalid expression") || z3ResultStr.contains("unexpected input")) {
                Map<String, Object> map2 = null;
                return map2;
            }
            Map<String, Object> solution = parser.parse(z3ResultStr, initialValues);
            if (solution != null && Z3StrSolver.checkSolution(constraints, solution)) {
                Map<String, Object> map3 = solution;
                return map3;
            }
            Map<String, Object> map4 = null;
            return map4;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 should not cause this exception!");
            map = null;
            return map;
        }
        catch (IOException e) {
            logger.error("IO exception during Z3 invocation!");
            map = null;
            return map;
        }
        finally {
            File tempFile = new File(z3TempFileName);
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private static int launchNewProcess(String z3StrCmd, String smtQuery, int timeout, OutputStream outputStream) throws IOException {
        final Process process = Runtime.getRuntime().exec(z3StrCmd);
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        logger.debug("Process output:");
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                process.destroy();
            }
        }, timeout);
        do {
            Z3StrSolver.readInputStream(stdout, outputStream);
            Z3StrSolver.readInputStream(stderr, null);
        } while (!Z3StrSolver.isFinished(process));
        int exitValue = process.exitValue();
        return exitValue;
    }

    private static void readInputStream(InputStream in, OutputStream out) throws IOException {
        InputStreamReader is = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            logger.debug(read);
            if (out != null) {
                byte[] bytes = (read + "\n").getBytes();
                out.write(bytes);
            }
            read = br.readLine();
        }
    }

    private static boolean isFinished(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException ex) {
            return false;
        }
    }
}

