/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import edu.uta.cse.dsc.AbstractVM;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerBinaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerComparison;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerUnaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.bv.RealComparison;
import org.evosuite.symbolic.expr.bv.RealToIntegerCast;
import org.evosuite.symbolic.expr.fp.IntegerToRealCast;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealUnaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.ConstraintFactory;
import org.evosuite.symbolic.vm.DoubleWordOperand;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.OperandStack;
import org.evosuite.symbolic.vm.PathConstraint;
import org.evosuite.symbolic.vm.SingleWordOperand;
import org.evosuite.symbolic.vm.SymbolicEnvironment;

public final class ArithmeticVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final PathConstraint pathConstraint;

    public ArithmeticVM(SymbolicEnvironment env, PathConstraint pathConstraint) {
        this.env = env;
        this.pathConstraint = pathConstraint;
    }

    private boolean zeroViolation(IntegerValue value, long valueConcrete) {
        IntegerConstant zero = ExpressionFactory.ICONST_0;
        IntegerConstraint zeroCheck = valueConcrete == 0L ? ConstraintFactory.eq(value, zero) : ConstraintFactory.neq(value, zero);
        if (zeroCheck.getLeftOperand().containsSymbolicVariable() || zeroCheck.getRightOperand().containsSymbolicVariable()) {
            this.pathConstraint.pushSupportingConstraint(zeroCheck);
        }
        return valueConcrete == 0L;
    }

    @Override
    public void POP() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand a = stack.popOperand();
        if (!(a instanceof SingleWordOperand)) {
            throw new IllegalStateException("pop should be applied iif top is SingleWordOperand");
        }
    }

    @Override
    public void POP2() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand top = stack.popOperand();
        if (top instanceof DoubleWordOperand) {
            return;
        }
        stack.popOperand();
    }

    @Override
    public void DUP() {
        Operand x = this.env.topFrame().operandStack.peekOperand();
        this.env.topFrame().operandStack.pushOperand(x);
    }

    @Override
    public void DUP_X1() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand a = stack.popOperand();
        Operand b = stack.popOperand();
        stack.pushOperand(a);
        stack.pushOperand(b);
        stack.pushOperand(a);
    }

    @Override
    public void DUP_X2() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand a = stack.popOperand();
        Operand b = stack.popOperand();
        if (b instanceof SingleWordOperand) {
            Operand c = stack.popOperand();
            stack.pushOperand(a);
            stack.pushOperand(c);
            stack.pushOperand(b);
            stack.pushOperand(a);
        } else {
            stack.pushOperand(a);
            stack.pushOperand(b);
            stack.pushOperand(a);
        }
    }

    @Override
    public void DUP2() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand a = stack.popOperand();
        if (a instanceof SingleWordOperand) {
            Operand b = stack.popOperand();
            stack.pushOperand(b);
            stack.pushOperand(a);
            stack.pushOperand(b);
            stack.pushOperand(a);
        } else {
            stack.pushOperand(a);
            stack.pushOperand(a);
        }
    }

    @Override
    public void DUP2_X1() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand expression = stack.popOperand();
        if (expression instanceof SingleWordOperand) {
            Operand a = expression;
            Operand b = stack.popOperand();
            Operand c = stack.popOperand();
            stack.pushOperand(b);
            stack.pushOperand(a);
            stack.pushOperand(c);
            stack.pushOperand(b);
            stack.pushOperand(a);
        } else {
            Operand a = expression;
            Operand b = stack.popOperand();
            stack.pushOperand(a);
            stack.pushOperand(b);
            stack.pushOperand(a);
        }
    }

    @Override
    public void DUP2_X2() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand first = stack.popOperand();
        Operand second = stack.popOperand();
        if (first instanceof DoubleWordOperand) {
            Operand a = first;
            if (second instanceof DoubleWordOperand) {
                Operand b = second;
                stack.pushOperand(a);
                stack.pushOperand(b);
                stack.pushOperand(a);
            } else {
                Operand b = second;
                Operand c = stack.popOperand();
                stack.pushOperand(a);
                stack.pushOperand(c);
                stack.pushOperand(b);
                stack.pushOperand(a);
            }
        } else {
            Operand a = first;
            Operand b = second;
            Operand third = stack.popOperand();
            if (third instanceof DoubleWordOperand) {
                Operand c = third;
                stack.pushOperand(b);
                stack.pushOperand(a);
                stack.pushOperand(c);
                stack.pushOperand(b);
                stack.pushOperand(a);
            } else {
                Operand c = third;
                Operand d = stack.popOperand();
                stack.pushOperand(b);
                stack.pushOperand(a);
                stack.pushOperand(d);
                stack.pushOperand(c);
                stack.pushOperand(b);
                stack.pushOperand(a);
            }
        }
    }

    @Override
    public void SWAP() {
        OperandStack stack = this.env.topFrame().operandStack;
        Operand a = stack.popOperand();
        Operand b = stack.popOperand();
        stack.pushOperand(a);
        stack.pushOperand(b);
    }

    @Override
    public void IADD() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value + right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.add(left, right, con);
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LADD() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value + right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.add(left, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void FADD() {
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        float con = left_concrete_value + right_concrete_value;
        RealValue realExpr = ExpressionFactory.add(left, right, con);
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DADD() {
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        double con = left_concrete_value + right_concrete_value;
        RealValue realExpr = ExpressionFactory.add(left, right, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void ISUB() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value - right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.MINUS, right, Long.valueOf(con));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LSUB() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value - right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.MINUS, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void FSUB() {
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        float con = left_concrete_value - right_concrete_value;
        RealBinaryExpression realExpr = new RealBinaryExpression(left, Operator.MINUS, right, Double.valueOf(con));
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DSUB() {
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        double con = left_concrete_value - right_concrete_value;
        RealBinaryExpression realExpr = new RealBinaryExpression(left, Operator.MINUS, right, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void IMUL() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value * right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.mul(left, right, con);
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LMUL() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value * right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.mul(left, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void FMUL() {
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        float con = left_concrete_value * right_concrete_value;
        RealValue realExpr = ExpressionFactory.mul(left, right, con);
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DMUL() {
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        double con = left_concrete_value * right_concrete_value;
        RealValue realExpr = ExpressionFactory.mul(left, right, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void IDIV(int rhsValue) {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        if (this.zeroViolation(right, rhsValue)) {
            return;
        }
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value / right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.div(left, right, con);
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LDIV(long rhsValue) {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        if (this.zeroViolation(right, rhsValue)) {
            return;
        }
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value / right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.div(left, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void FDIV(float rhsValue) {
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        float con = left_concrete_value / right_concrete_value;
        RealValue realExpr = ExpressionFactory.div(left, right, con);
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DDIV(double rhsValue) {
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        double con = left_concrete_value / right_concrete_value;
        RealValue realExpr = ExpressionFactory.div(left, right, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void IREM(int rhsValue) {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        if (this.zeroViolation(right, rhsValue)) {
            return;
        }
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value % right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.rem(left, right, con);
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void FREM(float rhs) {
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        float con = left_concrete_value % right_concrete_value;
        RealValue realExpr = ExpressionFactory.rem(left, right, con);
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DREM(double rhs) {
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        double con = left_concrete_value % right_concrete_value;
        RealValue realExpr = ExpressionFactory.rem(left, right, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void INEG() {
        IntegerValue param = this.env.topFrame().operandStack.popBv32();
        int param_concrete_value = ((Long)param.getConcreteValue()).intValue();
        if (!param.containsSymbolicVariable()) {
            param = ExpressionFactory.buildNewIntegerConstant(param_concrete_value);
        }
        int con = -param_concrete_value;
        IntegerUnaryExpression intExpr = new IntegerUnaryExpression(param, Operator.NEG, Long.valueOf(con));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LNEG() {
        IntegerValue param = this.env.topFrame().operandStack.popBv64();
        long param_concrete_value = (Long)param.getConcreteValue();
        if (!param.containsSymbolicVariable()) {
            param = ExpressionFactory.buildNewIntegerConstant(param_concrete_value);
        }
        long con = -param_concrete_value;
        IntegerUnaryExpression intExpr = new IntegerUnaryExpression(param, Operator.NEG, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void FNEG() {
        RealValue param = this.env.topFrame().operandStack.popFp32();
        float param_concrete_value = ((Double)param.getConcreteValue()).floatValue();
        if (!param.containsSymbolicVariable()) {
            param = ExpressionFactory.buildNewRealConstant(param_concrete_value);
        }
        float con = -param_concrete_value;
        RealUnaryExpression realExpr = new RealUnaryExpression(param, Operator.NEG, Double.valueOf(con));
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    @Override
    public void DNEG() {
        RealValue param = this.env.topFrame().operandStack.popFp64();
        double param_concrete_value = (Double)param.getConcreteValue();
        if (!param.containsSymbolicVariable()) {
            param = ExpressionFactory.buildNewRealConstant(param_concrete_value);
        }
        double con = -param_concrete_value;
        RealUnaryExpression realExpr = new RealUnaryExpression(param, Operator.NEG, con);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    @Override
    public void ISHL() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left_expr.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        int concrete_value = left_concrete_value << (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.SHL, right_expr, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void ISHR() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left_expr.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        int concrete_value = left_concrete_value >> (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.SHR, right_expr, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void IUSHR() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left_expr.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        int concrete_value = left_concrete_value >>> (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.USHR, right_expr, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LUSHR() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left_expr.getConcreteValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        long concrete_value = left_concrete_value >>> (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.USHR, right_expr, concrete_value);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void LSHR() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left_expr.getConcreteValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        long concrete_value = left_concrete_value >> (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.SHL, right_expr, concrete_value);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void LSHL() {
        IntegerValue right_expr = this.env.topFrame().operandStack.popBv32();
        IntegerValue left_expr = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left_expr.getConcreteValue();
        int right_concrete_value = ((Long)right_expr.getConcreteValue()).intValue();
        long concrete_value = left_concrete_value << (right_concrete_value & 0x1F);
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left_expr, Operator.SHL, right_expr, concrete_value);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void IAND() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value & right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IAND, right, Long.valueOf(con));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void IOR() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value | right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IOR, right, Long.valueOf(con));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void IXOR() {
        IntegerValue right = this.env.topFrame().operandStack.popBv32();
        IntegerValue left = this.env.topFrame().operandStack.popBv32();
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = ((Long)right.getConcreteValue()).intValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int con = left_concrete_value ^ right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IXOR, right, Long.valueOf(con));
        this.env.topFrame().operandStack.pushBv32(intExpr);
    }

    @Override
    public void LAND() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value & right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IAND, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void LOR() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value | right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IOR, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void LXOR() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value ^ right_concrete_value;
        IntegerBinaryExpression intExpr = new IntegerBinaryExpression(left, Operator.IXOR, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void IINC(int i, int value) {
        IntegerConstant right = ExpressionFactory.buildNewIntegerConstant(value);
        IntegerValue left = this.env.topFrame().localsTable.getBv32Local(i);
        int left_concrete_value = ((Long)left.getConcreteValue()).intValue();
        int right_concrete_value = value;
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        int con = left_concrete_value + right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.add(left, right, con);
        this.env.topFrame().localsTable.setBv32Local(i, intExpr);
    }

    @Override
    public void LCMP() {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        int concrete_value = 0;
        if (left_concrete_value == right_concrete_value) {
            concrete_value = 0;
        } else if (left_concrete_value > right_concrete_value) {
            concrete_value = 1;
        } else {
            assert (left_concrete_value < right_concrete_value);
            concrete_value = -1;
        }
        IntegerComparison intComp = new IntegerComparison(left, right, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(intComp);
    }

    @Override
    public void FCMPL() {
        int concrete_value;
        RealValue right = this.env.topFrame().operandStack.popFp32();
        RealValue left = this.env.topFrame().operandStack.popFp32();
        float left_concrete_value = ((Double)left.getConcreteValue()).floatValue();
        float right_concrete_value = ((Double)right.getConcreteValue()).floatValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        if (new Double(left_concrete_value).isNaN() || new Double(right_concrete_value).isNaN()) {
            concrete_value = 1;
        } else if (left_concrete_value == right_concrete_value) {
            concrete_value = 0;
        } else if (left_concrete_value > right_concrete_value) {
            concrete_value = 1;
        } else {
            assert (left_concrete_value < right_concrete_value);
            concrete_value = -1;
        }
        RealComparison ret = new RealComparison(left, right, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(ret);
    }

    @Override
    public void FCMPG() {
        this.FCMPL();
    }

    @Override
    public void DCMPL() {
        int concrete_value;
        RealValue right = this.env.topFrame().operandStack.popFp64();
        RealValue left = this.env.topFrame().operandStack.popFp64();
        double left_concrete_value = (Double)left.getConcreteValue();
        double right_concrete_value = (Double)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewRealConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewRealConstant(right_concrete_value);
        }
        if (new Double(left_concrete_value).isNaN() || new Double(right_concrete_value).isNaN()) {
            concrete_value = 1;
        } else if (left_concrete_value == right_concrete_value) {
            concrete_value = 0;
        } else if (left_concrete_value > right_concrete_value) {
            concrete_value = 1;
        } else {
            assert (left_concrete_value < right_concrete_value);
            concrete_value = -1;
        }
        RealComparison ret = new RealComparison(left, right, Long.valueOf(concrete_value));
        this.env.topFrame().operandStack.pushBv32(ret);
    }

    @Override
    public void DCMPG() {
        this.DCMPL();
    }

    @Override
    public void I2L() {
        IntegerValue intExpr = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }

    @Override
    public void I2F() {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv32();
        int integerValue = ((Long)integerExpr.getConcreteValue()).intValue();
        float concreteValue = integerValue;
        AbstractExpression realExpr = !integerExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewRealConstant(concreteValue) : new IntegerToRealCast(integerExpr, Double.valueOf(concreteValue));
        this.env.topFrame().operandStack.pushFp32((RealValue)((Object)realExpr));
    }

    @Override
    public void I2D() {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv32();
        int integerValue = ((Long)integerExpr.getConcreteValue()).intValue();
        double concreteValue = integerValue;
        AbstractExpression realExpr = !integerExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewRealConstant(concreteValue) : new IntegerToRealCast(integerExpr, concreteValue);
        this.env.topFrame().operandStack.pushFp64((RealValue)((Object)realExpr));
    }

    @Override
    public void L2I() {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv64();
        this.env.topFrame().operandStack.pushBv32(integerExpr);
    }

    @Override
    public void L2F() {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv64();
        long longValue = (Long)integerExpr.getConcreteValue();
        float concreteValue = longValue;
        AbstractExpression realExpr = !integerExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewRealConstant(concreteValue) : new IntegerToRealCast(integerExpr, Double.valueOf(concreteValue));
        this.env.topFrame().operandStack.pushFp32((RealValue)((Object)realExpr));
    }

    @Override
    public void L2D() {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv64();
        long longValue = (Long)integerExpr.getConcreteValue();
        double concreteValue = longValue;
        AbstractExpression realExpr = !integerExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewRealConstant(concreteValue) : new IntegerToRealCast(integerExpr, concreteValue);
        this.env.topFrame().operandStack.pushFp64((RealValue)((Object)realExpr));
    }

    @Override
    public void F2I() {
        RealValue realExpr = this.env.topFrame().operandStack.popFp32();
        float doubleValue = ((Double)realExpr.getConcreteValue()).floatValue();
        int concreteValue = (int)doubleValue;
        AbstractExpression intExpr = !realExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewIntegerConstant(concreteValue) : new RealToIntegerCast(realExpr, Long.valueOf(concreteValue));
        this.env.topFrame().operandStack.pushBv32((IntegerValue)((Object)intExpr));
    }

    @Override
    public void F2L() {
        RealValue realExpr = this.env.topFrame().operandStack.popFp32();
        float floatValue = ((Double)realExpr.getConcreteValue()).floatValue();
        long concreteValue = (long)floatValue;
        AbstractExpression intExpr = !realExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewIntegerConstant(concreteValue) : new RealToIntegerCast(realExpr, concreteValue);
        this.env.topFrame().operandStack.pushBv64((IntegerValue)((Object)intExpr));
    }

    @Override
    public void F2D() {
        RealValue e = this.env.topFrame().operandStack.popFp32();
        this.env.topFrame().operandStack.pushFp64(e);
    }

    @Override
    public void D2I() {
        RealValue realExpr = this.env.topFrame().operandStack.popFp64();
        double doubleValue = (Double)realExpr.getConcreteValue();
        int concreteValue = (int)doubleValue;
        AbstractExpression intExpr = !realExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewIntegerConstant(concreteValue) : new RealToIntegerCast(realExpr, Long.valueOf(concreteValue));
        this.env.topFrame().operandStack.pushBv32((IntegerValue)((Object)intExpr));
    }

    @Override
    public void D2L() {
        RealValue realExpr = this.env.topFrame().operandStack.popFp64();
        double doubleValue = (Double)realExpr.getConcreteValue();
        long concreteValue = (long)doubleValue;
        AbstractExpression intExpr = !realExpr.containsSymbolicVariable() ? ExpressionFactory.buildNewIntegerConstant(concreteValue) : new RealToIntegerCast(realExpr, concreteValue);
        this.env.topFrame().operandStack.pushBv64((IntegerValue)((Object)intExpr));
    }

    @Override
    public void D2F() {
        RealValue e = this.env.topFrame().operandStack.popFp64();
        this.env.topFrame().operandStack.pushFp32(e);
    }

    @Override
    public void I2B() {
    }

    @Override
    public void I2C() {
    }

    @Override
    public void I2S() {
    }

    @Override
    public void LREM(long rhs) {
        IntegerValue right = this.env.topFrame().operandStack.popBv64();
        IntegerValue left = this.env.topFrame().operandStack.popBv64();
        if (this.zeroViolation(right, rhs)) {
            return;
        }
        long left_concrete_value = (Long)left.getConcreteValue();
        long right_concrete_value = (Long)right.getConcreteValue();
        if (!left.containsSymbolicVariable()) {
            left = ExpressionFactory.buildNewIntegerConstant(left_concrete_value);
        }
        if (!right.containsSymbolicVariable()) {
            right = ExpressionFactory.buildNewIntegerConstant(right_concrete_value);
        }
        long con = left_concrete_value % right_concrete_value;
        IntegerValue intExpr = ExpressionFactory.rem(left, right, con);
        this.env.topFrame().operandStack.pushBv64(intExpr);
    }
}

