/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.lang.reflect.Member;
import org.evosuite.symbolic.vm.LocalsTable;
import org.evosuite.symbolic.vm.OperandStack;
import org.objectweb.asm.Type;

public abstract class Frame {
    private boolean weInvokedInstrumentedCode = true;
    boolean invokeNeedsThis;
    public final OperandStack operandStack = new OperandStack();
    final LocalsTable localsTable;

    boolean weInvokedInstrumentedCode() {
        return this.weInvokedInstrumentedCode;
    }

    public void invokeInstrumentedCode(boolean b) {
        this.weInvokedInstrumentedCode = b;
    }

    protected Frame(int maxLocals) {
        this.localsTable = new LocalsTable(maxLocals);
    }

    public abstract Member getMember();

    public abstract int getNrFormalParameters();

    public abstract int getNrFormalParametersTotal();

    private void disposeOperands(int nrFormalParameters) {
        for (int i = 0; i < nrFormalParameters; ++i) {
            this.operandStack.popOperand();
        }
    }

    void disposeMethInvokeArgs(String methDesc) {
        this.disposeOperands(Type.getArgumentTypes(methDesc).length);
        if (this.invokeNeedsThis) {
            this.operandStack.popOperand();
        }
    }

    void disposeMethInvokeArgs(Frame frame) {
        this.disposeOperands(frame.getNrFormalParametersTotal());
    }

    public String toString() {
        return this.getMember().getName() + "--" + this.operandStack.toString();
    }
}

