/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.Bv32Operand;
import org.evosuite.symbolic.vm.Bv64Operand;
import org.evosuite.symbolic.vm.Fp32Operand;
import org.evosuite.symbolic.vm.Fp64Operand;
import org.evosuite.symbolic.vm.NullReference;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.Reference;
import org.evosuite.symbolic.vm.ReferenceOperand;

public final class OperandStack
implements Iterable<Operand> {
    private final Deque<Operand> stack = new LinkedList<Operand>();

    public void pushRef(Reference r) {
        this.stack.push(new ReferenceOperand(r));
    }

    public void pushBv32(IntegerValue e) {
        this.stack.push(new Bv32Operand(e));
    }

    public void pushBv64(IntegerValue e) {
        this.stack.push(new Bv64Operand(e));
    }

    public void pushFp32(RealValue e) {
        this.stack.push(new Fp32Operand(e));
    }

    public void pushFp64(RealValue e) {
        this.stack.push(new Fp64Operand(e));
    }

    public Reference popRef() {
        Operand ret_val = this.popOperand();
        ReferenceOperand ref = (ReferenceOperand)ret_val;
        return ref.getReference();
    }

    public IntegerValue popBv32() {
        Operand x = this.popOperand();
        Bv32Operand e = (Bv32Operand)x;
        return e.getIntegerExpression();
    }

    public IntegerValue popBv64() {
        Operand x = this.popOperand();
        Bv64Operand e = (Bv64Operand)x;
        return e.getIntegerExpression();
    }

    public RealValue popFp32() {
        Operand x = this.popOperand();
        Fp32Operand e = (Fp32Operand)x;
        return e.getRealExpression();
    }

    public RealValue popFp64() {
        Operand x = this.popOperand();
        Fp64Operand e = (Fp64Operand)x;
        return e.getRealExpression();
    }

    public Operand popOperand() {
        Operand ret_val = this.stack.pop();
        return ret_val;
    }

    public void clearOperands() {
        this.stack.clear();
    }

    public void pushOperand(Operand operand) {
        this.stack.push(operand);
    }

    public RealValue peekFp64() {
        Operand operand = this.stack.peek();
        Fp64Operand fp64 = (Fp64Operand)operand;
        return fp64.getRealExpression();
    }

    public RealValue peekFp32() {
        Operand operand = this.stack.peek();
        Fp32Operand fp32 = (Fp32Operand)operand;
        return fp32.getRealExpression();
    }

    public IntegerValue peekBv64() {
        Operand operand = this.stack.peek();
        Bv64Operand bv64 = (Bv64Operand)operand;
        return bv64.getIntegerExpression();
    }

    public IntegerValue peekBv32() {
        Operand operand = this.stack.peek();
        Bv32Operand bv32 = (Bv32Operand)operand;
        return bv32.getIntegerExpression();
    }

    public Operand peekOperand() {
        return this.stack.peek();
    }

    @Override
    public Iterator<Operand> iterator() {
        return this.stack.iterator();
    }

    public Reference peekRef() {
        Operand operand = this.peekOperand();
        ReferenceOperand refOp = (ReferenceOperand)operand;
        Reference ref = refOp.getReference();
        return ref;
    }

    public String toString() {
        if (this.stack.isEmpty()) {
            return "<<EMPTY_OPERAND_STACK>>";
        }
        StringBuffer buff = new StringBuffer();
        for (Operand operand : this) {
            buff.append(operand.toString() + "\n");
        }
        return buff.toString();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void pushNullRef() {
        this.stack.push(new ReferenceOperand(NullReference.getInstance()));
    }
}

