/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.vm.ConstraintNormalizer;

public final class PathConstraint {
    private BranchCondition previousBranchCondition = null;
    private final Stack<BranchCondition> branchConditions = new Stack();
    private final LinkedList<Constraint<?>> currentSupportingConstraints = new LinkedList();

    private Constraint<?> normalizeConstraint(IntegerConstraint c) {
        return ConstraintNormalizer.normalize(c);
    }

    public void pushSupportingConstraint(IntegerConstraint c) {
        Constraint<?> normalizedConstraint = this.normalizeConstraint(c);
        this.currentSupportingConstraints.add(normalizedConstraint);
    }

    public void pushBranchCondition(String className, String methName, int branchIndex, IntegerConstraint c) {
        BranchCondition new_branch;
        Constraint<?> normalizedConstraint = this.normalizeConstraint(c);
        LinkedList branch_supporting_constraints = new LinkedList(this.currentSupportingConstraints);
        this.previousBranchCondition = new_branch = new BranchCondition(this.previousBranchCondition, className, methName, branchIndex, normalizedConstraint, branch_supporting_constraints);
        this.branchConditions.push(new_branch);
        this.currentSupportingConstraints.clear();
    }

    public List<BranchCondition> getBranchConditions() {
        return new LinkedList<BranchCondition>(this.branchConditions);
    }
}

