/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.NonNullReference;
import org.evosuite.symbolic.vm.NullReference;
import org.evosuite.symbolic.vm.Reference;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolicHeap {
    protected static final Logger logger = LoggerFactory.getLogger(SymbolicHeap.class);
    private static final int SYMBOLIC_GC_THRESHOLD = 9000000;
    private int newInstanceCount = 0;
    private final Map<Integer, NonNullReference> nonNullRefs = new HashMap<Integer, NonNullReference>();
    private final Map<FieldKey, Map<NonNullReference, Expression<?>>> symb_fields = new HashMap();
    private final Map<FieldKey, Expression<?>> symb_static_fields = new HashMap();
    private int modCount;
    private final Map<NonNullReference, Map<Integer, Expression<?>>> symb_arrays = new HashMap();
    public static final String $STRING_BUILDER_CONTENTS = "$stringBuilder_contents";
    public static final String $STRING_BUFFER_CONTENTS = "$stringBuffer_contents";
    public static final String $BIG_INTEGER_CONTENTS = "$bigInteger_contents";
    public static final String $STRING_TOKENIZER_VALUE = "$stringTokenizerValue";
    public static final String $STRING_READER_VALUE = "$stringReaderValue";
    public static final String $MATCHER_INPUT = "$matcherInput";
    public static final String $BOOLEAN_VALUE = "$booleanValue";
    public static final String $BYTE_VALUE = "$byteValue";
    public static final String $CHAR_VALUE = "$charValue";
    public static final String $SHORT_VALUE = "$shortValue";
    public static final String $LONG_VALUE = "$longValue";
    public static final String $INT_VALUE = "$intValue";
    public static final String $FLOAT_VALUE = "$floatValue";
    public static final String $DOUBLE_VALUE = "$doubleValue";
    public static final String $STRING_VALUE = "$stringValue";

    public NonNullReference newReference(Type objectType) {
        if (objectType.getClassName() == null) {
            throw new IllegalArgumentException();
        }
        return new NonNullReference(objectType, this.newInstanceCount++);
    }

    public void putField(String owner, String name, Object conc_receiver, NonNullReference symb_receiver, Expression<?> symb_value) {
        Map<NonNullReference, Expression<?>> symb_field = this.getOrCreateSymbolicField(owner, name);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            symb_field.remove(symb_receiver);
        } else {
            symb_field.put(symb_receiver, symb_value);
        }
        this.monitor_gc();
    }

    private void monitor_gc() {
        ++this.modCount;
        if (this.modCount > 9000000) {
            this.symbolic_gc();
            this.modCount = 0;
        }
    }

    private Map<NonNullReference, Expression<?>> getOrCreateSymbolicField(String owner, String name) {
        FieldKey k = new FieldKey(owner, name);
        Map<NonNullReference, Expression<?>> symb_field = this.symb_fields.get(k);
        if (symb_field == null) {
            symb_field = new HashMap();
            this.symb_fields.put(k, symb_field);
        }
        return symb_field;
    }

    public IntegerValue getField(String owner, String name, Object conc_receiver, NonNullReference symb_receiver, long conc_value) {
        Map<NonNullReference, Expression<?>> symb_field = this.getOrCreateSymbolicField(owner, name);
        IntegerValue symb_value = (IntegerValue)symb_field.get(symb_receiver);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        this.monitor_gc();
        return symb_value;
    }

    private void symbolic_gc() {
        logger.debug("DSE: starting symbolic heap garbage collection");
        HashSet<NonNullReference> collected_refs = new HashSet<NonNullReference>();
        for (Map.Entry<FieldKey, Map<NonNullReference, Expression<?>>> symb_field_entry : this.symb_fields.entrySet()) {
            Map<NonNullReference, Expression<?>> symb_field = symb_field_entry.getValue();
            HashSet<NonNullReference> hashSet = new HashSet<NonNullReference>(symb_field.keySet());
            for (NonNullReference non_null_ref : hashSet) {
                if (!non_null_ref.isCollectable()) continue;
                symb_field.remove(non_null_ref);
                collected_refs.add(non_null_ref);
            }
        }
        HashSet<NonNullReference> keySet = new HashSet<NonNullReference>(this.symb_arrays.keySet());
        for (NonNullReference array_ref : keySet) {
            if (!array_ref.isCollectable()) continue;
            this.symb_arrays.remove(array_ref);
            collected_refs.add(array_ref);
        }
        HashSet<Map.Entry<Integer, NonNullReference>> entry_set = new HashSet<Map.Entry<Integer, NonNullReference>>(this.nonNullRefs.entrySet());
        for (Map.Entry entry : entry_set) {
            if (!((NonNullReference)entry.getValue()).isCollectable()) continue;
            this.nonNullRefs.remove(entry.getKey());
            collected_refs.add((NonNullReference)entry.getValue());
        }
        logger.debug("Nr of collected non-null references = " + collected_refs.size());
        logger.debug("DSE: symbolic heap garbage collection ended");
    }

    public RealValue getField(String className, String fieldName, Object conc_receiver, NonNullReference symb_receiver, double conc_value) {
        Map<NonNullReference, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        RealValue symb_value = (RealValue)symb_field.get(symb_receiver);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        this.monitor_gc();
        return symb_value;
    }

    public StringValue getField(String className, String fieldName, Object conc_receiver, NonNullReference symb_receiver, String conc_value) {
        Map<NonNullReference, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        StringValue symb_value = (StringValue)symb_field.get(symb_receiver);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        this.monitor_gc();
        return symb_value;
    }

    public Expression<?> getField(String className, String fieldName, Object conc_receiver, NonNullReference symb_receiver) {
        Map<NonNullReference, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        Expression<?> symb_value = symb_field.get(symb_receiver);
        this.monitor_gc();
        return symb_value;
    }

    public void putStaticField(String owner, String name, Expression<?> symb_value) {
        FieldKey k = new FieldKey(owner, name);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            this.symb_static_fields.remove(k);
        } else {
            this.symb_static_fields.put(k, symb_value);
        }
        this.monitor_gc();
    }

    public IntegerValue getStaticField(String owner, String name, long conc_value) {
        FieldKey k = new FieldKey(owner, name);
        IntegerValue symb_value = (IntegerValue)this.symb_static_fields.get(k);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        this.monitor_gc();
        return symb_value;
    }

    public RealValue getStaticField(String owner, String name, double conc_value) {
        FieldKey k = new FieldKey(owner, name);
        RealValue symb_value = (RealValue)this.symb_static_fields.get(k);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        this.monitor_gc();
        return symb_value;
    }

    public StringValue getStaticField(String owner, String name, String conc_value) {
        FieldKey k = new FieldKey(owner, name);
        StringValue symb_value = (StringValue)this.symb_static_fields.get(k);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        this.monitor_gc();
        return symb_value;
    }

    public Reference getReference(Object conc_ref) {
        if (conc_ref == null) {
            return NullReference.getInstance();
        }
        int identityHashCode = System.identityHashCode(conc_ref);
        NonNullReference symb_ref = this.nonNullRefs.get(identityHashCode);
        if (symb_ref == null || symb_ref.getWeakConcreteObject() != conc_ref) {
            symb_ref = new NonNullReference(Type.getType(conc_ref.getClass()), this.newInstanceCount++);
            symb_ref.initializeReference(conc_ref);
            this.nonNullRefs.put(identityHashCode, symb_ref);
        }
        return symb_ref;
    }

    public void array_store(Object conc_array, NonNullReference symb_array, int conc_index, Expression<?> symb_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            symb_array_contents.remove(conc_index);
        } else {
            symb_array_contents.put(conc_index, symb_value);
        }
        this.monitor_gc();
    }

    private Map<Integer, Expression<?>> getOrCreateSymbolicArray(NonNullReference symb_array_ref) {
        Map<Integer, Expression<?>> symb_array_contents = this.symb_arrays.get(symb_array_ref);
        if (symb_array_contents == null) {
            symb_array_contents = new HashMap();
            this.symb_arrays.put(symb_array_ref, symb_array_contents);
        }
        return symb_array_contents;
    }

    public StringValue array_load(NonNullReference symb_array, int conc_index, String conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        StringValue symb_value = (StringValue)symb_array_contents.get(conc_index);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        this.monitor_gc();
        return symb_value;
    }

    public IntegerValue array_load(NonNullReference symb_array, int conc_index, long conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        IntegerValue symb_value = (IntegerValue)symb_array_contents.get(conc_index);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        this.monitor_gc();
        return symb_value;
    }

    public RealValue array_load(NonNullReference symb_array, int conc_index, double conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        RealValue symb_value = (RealValue)symb_array_contents.get(conc_index);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        this.monitor_gc();
        return symb_value;
    }

    public void initializeReference(Object conc_ref, Reference symb_ref) {
        NonNullReference symb_non_null_ref;
        if (conc_ref != null && !(symb_non_null_ref = (NonNullReference)symb_ref).isInitialized()) {
            symb_non_null_ref.initializeReference(conc_ref);
            int identityHashCode = System.identityHashCode(conc_ref);
            this.nonNullRefs.put(identityHashCode, symb_non_null_ref);
        }
    }

    private static final class FieldKey {
        private String owner;
        private String name;

        public FieldKey(String owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public int hashCode() {
            return this.owner.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass().equals(FieldKey.class)) {
                FieldKey that = (FieldKey)o;
                return this.owner.equals(that.owner) && this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.owner + "/" + this.name;
        }
    }
}

