/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerUnaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealUnaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class ABS {
    private static final String ABS_FUNCTION_NAME = "abs";

    public static final class ABS_L
    extends SymbolicFunction {
        public ABS_L(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, ABS.ABS_FUNCTION_NAME, Types.L2L_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            long res = this.getConcLongRetVal();
            IntegerValue intExpression = this.getSymbIntegerArgument(0);
            IntegerValue sym_val = intExpression.containsSymbolicVariable() ? new IntegerUnaryExpression(intExpression, Operator.ABS, res) : this.getSymbIntegerRetVal();
            return sym_val;
        }
    }

    public static final class ABS_I
    extends SymbolicFunction {
        public ABS_I(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, ABS.ABS_FUNCTION_NAME, Types.I2I_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            int res = this.getConcIntRetVal();
            IntegerValue intExpression = this.getSymbIntegerArgument(0);
            IntegerValue sym_val = intExpression.containsSymbolicVariable() ? new IntegerUnaryExpression(intExpression, Operator.ABS, Long.valueOf(res)) : this.getSymbIntegerRetVal();
            return sym_val;
        }
    }

    public static final class ABS_F
    extends SymbolicFunction {
        public ABS_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, ABS.ABS_FUNCTION_NAME, Types.F2F_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            float res = this.getConcFloatRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            RealValue sym_val = realExpression.containsSymbolicVariable() ? new RealUnaryExpression(realExpression, Operator.ABS, Double.valueOf(res)) : this.getSymbRealRetVal();
            return sym_val;
        }
    }

    public static final class ABS_D
    extends SymbolicFunction {
        public ABS_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, ABS.ABS_FUNCTION_NAME, Types.D2D_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            double res = this.getConcDoubleRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            RealValue sym_val = realExpression.containsSymbolicVariable() ? new RealUnaryExpression(realExpression, Operator.ABS, res) : this.getSymbRealRetVal();
            return sym_val;
        }
    }
}

