/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerBinaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class MIN {
    private static final String MIN = "min";

    public static class MIN_L
    extends SymbolicFunction {
        public MIN_L(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.MIN.MIN, Types.LL2L_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            IntegerValue minExpr;
            long res = this.getConcLongRetVal();
            IntegerValue left = this.getSymbIntegerArgument(0);
            IntegerValue right = this.getSymbIntegerArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.MIN;
                minExpr = new IntegerBinaryExpression(left, op, right, res);
            } else {
                minExpr = this.getSymbIntegerRetVal();
            }
            return minExpr;
        }
    }

    public static final class MIN_I
    extends SymbolicFunction {
        public MIN_I(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.MIN.MIN, Types.II2I_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            IntegerValue minExpr;
            int res = this.getConcIntRetVal();
            IntegerValue left = this.getSymbIntegerArgument(0);
            IntegerValue right = this.getSymbIntegerArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.MIN;
                minExpr = new IntegerBinaryExpression(left, op, right, Long.valueOf(res));
            } else {
                minExpr = this.getSymbIntegerRetVal();
            }
            return minExpr;
        }
    }

    public static final class MIN_F
    extends SymbolicFunction {
        public MIN_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.MIN.MIN, Types.FF2F_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue minExpr;
            float res = this.getConcFloatRetVal();
            RealValue left = this.getSymbRealArgument(0);
            RealValue right = this.getSymbRealArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.MIN;
                minExpr = new RealBinaryExpression(left, op, right, Double.valueOf(res));
            } else {
                minExpr = this.getSymbRealRetVal();
            }
            return minExpr;
        }
    }

    public static final class MIN_D
    extends SymbolicFunction {
        public MIN_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, org.evosuite.symbolic.vm.math.MIN.MIN, Types.DD2D_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue minExpr;
            double res = this.getConcDoubleRetVal();
            RealValue left = this.getSymbRealArgument(0);
            RealValue right = this.getSymbRealArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.MIN;
                minExpr = new RealBinaryExpression(left, op, right, res);
            } else {
                minExpr = this.getSymbRealRetVal();
            }
            return minExpr;
        }
    }
}

