/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.capture;

import org.evosuite.classpath.ResourceList;
import org.objectweb.asm.Type;

public final class CaptureUtil {
    private CaptureUtil() {
    }

    public static Class<?> loadClass(String internalClassName) {
        String className = ResourceList.getClassNameFromResourcePath(internalClassName);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Class<?> getClassFromDesc(String desc) {
        Type type = Type.getType(desc);
        if (type.equals(Type.BOOLEAN_TYPE)) {
            return Boolean.TYPE;
        }
        if (type.equals(Type.BYTE_TYPE)) {
            return Byte.TYPE;
        }
        if (type.equals(Type.CHAR_TYPE)) {
            return Character.TYPE;
        }
        if (type.equals(Type.DOUBLE_TYPE)) {
            return Double.TYPE;
        }
        if (type.equals(Type.FLOAT_TYPE)) {
            return Float.TYPE;
        }
        if (type.equals(Type.INT_TYPE)) {
            return Integer.TYPE;
        }
        if (type.equals(Type.LONG_TYPE)) {
            return Long.TYPE;
        }
        if (type.equals(Type.SHORT_TYPE)) {
            return Short.TYPE;
        }
        try {
            return Class.forName(ResourceList.getClassNameFromResourcePath(type.getInternalName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

