/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutionTracer;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllMethodsTestChromosomeFactory
implements ChromosomeFactory<TestChromosome> {
    private static final long serialVersionUID = -420224349882780856L;
    protected static final Logger logger = LoggerFactory.getLogger(AllMethodsTestChromosomeFactory.class);
    private static Set<GenericAccessibleObject<?>> attemptedMethods = new LinkedHashSet();
    private static Set<GenericAccessibleObject<?>> remainingMethods = new LinkedHashSet();
    private static List<GenericAccessibleObject<?>> allMethods = new LinkedList();

    public AllMethodsTestChromosomeFactory() {
        allMethods.addAll(TestCluster.getInstance().getTestCalls());
        Randomness.shuffle(allMethods);
        this.reset();
    }

    private TestCase getRandomTestCase(int size) {
        boolean tracerEnabled = ExecutionTracer.isEnabled();
        if (tracerEnabled) {
            ExecutionTracer.disable();
        }
        TestCase test = this.getNewTestCase();
        int num = 0;
        int length = Randomness.nextInt(size);
        while (length == 0) {
            length = Randomness.nextInt(size);
        }
        while (test.size() < length && num < Properties.MAX_ATTEMPTS) {
            if (remainingMethods.size() == 0) {
                this.reset();
            }
            GenericAccessibleObject<?> call = Randomness.choice(remainingMethods);
            attemptedMethods.add(call);
            remainingMethods.remove(call);
            try {
                TestFactory testFactory = TestFactory.getInstance();
                if (call.isMethod()) {
                    testFactory.addMethod(test, (GenericMethod)call, test.size(), 0);
                } else if (call.isConstructor()) {
                    testFactory.addConstructor(test, (GenericConstructor)call, test.size(), 0);
                } else assert (false) : "Found test call that is neither method nor constructor";
            }
            catch (ConstructionFailedException e) {
                // empty catch block
            }
            ++num;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Randomized test case:" + test.toCode());
        }
        if (tracerEnabled) {
            ExecutionTracer.enable();
        }
        return test;
    }

    @Override
    public TestChromosome getChromosome() {
        TestChromosome c = new TestChromosome();
        c.test = this.getRandomTestCase(Properties.CHROMOSOME_LENGTH);
        return c;
    }

    protected TestCase getNewTestCase() {
        return new DefaultTestCase();
    }

    public int getNumUncoveredMethods() {
        return remainingMethods.size();
    }

    public void reset() {
        remainingMethods.addAll(allMethods);
        attemptedMethods.clear();
    }
}

