/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.evosuite.Properties;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.AbstractStatement;
import org.evosuite.testcase.ArrayIndex;
import org.evosuite.testcase.ArrayReference;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.EvosuiteError;
import org.evosuite.testcase.FieldReference;
import org.evosuite.testcase.NullReference;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class AssignmentStatement
extends AbstractStatement {
    private static final long serialVersionUID = 2051431241124468349L;
    protected VariableReference parameter;

    public AssignmentStatement(TestCase tc, VariableReference var, VariableReference value) {
        super(tc, var);
        this.parameter = value;
    }

    public VariableReference getValue() {
        return this.parameter;
    }

    @Override
    public StatementInterface copy(TestCase newTestCase, int offset) {
        try {
            VariableReference newParam = this.parameter.copy(newTestCase, offset);
            VariableReference newTarget = this.retval.copy(newTestCase, offset);
            AssignmentStatement copy = new AssignmentStatement(newTestCase, newTarget, newParam);
            return copy;
        }
        catch (Exception e) {
            logger.info("Error cloning statement " + this.getCode());
            logger.info("In test: " + this.tc.toCode());
            logger.info("New test: " + newTestCase.toCode());
            e.printStackTrace();
            assert (false) : e.toString();
            return null;
        }
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        return super.exceptionHandler(new AbstractStatement.Executer(){

            @Override
            public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                try {
                    Object value = AssignmentStatement.this.parameter.getObject(scope);
                    AssignmentStatement.this.retval.setObject(scope, value);
                }
                catch (IllegalArgumentException e) {
                    AbstractStatement.logger.error("Error assigning value of type " + AssignmentStatement.this.parameter.getSimpleClassName() + " defined at statement " + AssignmentStatement.this.tc.getStatement(AssignmentStatement.this.parameter.getStPosition()).getCode() + ", assignment statement: " + AssignmentStatement.this.tc.getStatement(AssignmentStatement.this.retval.getStPosition()).getCode() + "; SUT=" + Properties.TARGET_CLASS);
                    throw e;
                }
                catch (CodeUnderTestException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new EvosuiteError(e);
                }
            }

            @Override
            public Set<Class<? extends Throwable>> throwableExceptions() {
                HashSet<Class<? extends Throwable>> t = new HashSet<Class<? extends Throwable>>();
                t.add(AssertionError.class);
                return t;
            }
        });
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> vars = new LinkedHashSet<VariableReference>();
        vars.add(this.retval);
        vars.add(this.parameter);
        if (this.retval.getAdditionalVariableReference() != null) {
            vars.add(this.retval.getAdditionalVariableReference());
        }
        if (this.parameter.getAdditionalVariableReference() != null) {
            vars.add(this.parameter.getAdditionalVariableReference());
        }
        vars.addAll(this.getAssertionReferences());
        return vars;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (this.parameter.equals(var1)) {
            this.parameter = var2;
        } else {
            this.parameter.replaceAdditionalVariableReference(var1, var2);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + this.retval.hashCode() + (this.parameter == null ? 0 : this.parameter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)obj;
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        return !(this.retval == null ? other.retval != null : !this.retval.equals(other.retval));
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        this.parameter.loadBytecode(mg, locals);
        Class<?> clazz = this.parameter.getVariableClass();
        if (this.parameter.isPrimitive() && !this.retval.isPrimitive()) {
            mg.box(Type.getType(this.parameter.getVariableClass()));
            clazz = this.parameter.getGenericClass().getBoxedType();
        }
        if (!clazz.equals(this.retval.getVariableClass())) {
            mg.cast(Type.getType(clazz), Type.getType(this.retval.getVariableClass()));
        }
        this.retval.storeBytecode(mg, locals);
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        return new ArrayList<VariableReference>(this.getVariableReferences());
    }

    @Override
    public boolean isValid() {
        assert (super.isValid());
        this.parameter.getStPosition();
        return true;
    }

    @Override
    public boolean same(StatementInterface s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)s;
        if (this.parameter == null ? other.parameter != null : !this.parameter.same(other.parameter)) {
            return false;
        }
        return !(this.retval == null ? other.retval != null : !this.retval.same(other.retval));
    }

    private Set<VariableReference> getSourceReplacements() {
        LinkedHashSet<VariableReference> variables = new LinkedHashSet<VariableReference>();
        for (int i = 0; i < this.retval.getStPosition() && i < this.tc.size(); ++i) {
            VariableReference value = this.tc.getReturnValue(i);
            if (value == null) continue;
            if (value instanceof ArrayReference) {
                if (!GenericClass.isAssignable(value.getComponentType(), this.parameter.getType())) continue;
                for (int index = 0; index < ((ArrayReference)value).getArrayLength(); ++index) {
                    variables.add(new ArrayIndex(this.tc, (ArrayReference)value, index));
                }
                continue;
            }
            if (value instanceof ArrayIndex) {
                if (!value.isAssignableFrom(this.parameter.getType())) continue;
                variables.add(value);
                continue;
            }
            if (value.isPrimitive() || value instanceof NullReference) continue;
            for (Field field : TestClusterGenerator.getAccessibleFields(value.getVariableClass())) {
                FieldReference f = new FieldReference(this.tc, new GenericField(field, value.getGenericClass()), value);
                if (f.getDepth() > 2 || !f.isAssignableFrom(this.parameter.getType())) continue;
                variables.add(f);
            }
        }
        return variables;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        assert (this.isValid());
        if (Randomness.nextDouble() < 0.5) {
            VariableReference newRetVal;
            Set<VariableReference> objects = this.getSourceReplacements();
            objects.remove(this.retval);
            objects.remove(this.parameter);
            if (!objects.isEmpty() && this.parameter.isAssignableTo(newRetVal = Randomness.choice(objects)) && this.parameter.isArray() == newRetVal.isArray()) {
                this.retval = newRetVal;
                assert (this.isValid());
                return true;
            }
        } else {
            VariableReference choice;
            List<VariableReference> objects = test.getObjects(this.parameter.getType(), this.retval.getStPosition());
            objects.remove(this.retval);
            objects.remove(this.parameter);
            if (!objects.isEmpty() && (choice = Randomness.choice(objects)).isAssignableTo(this.retval)) {
                if (this.retval.getGenericClass().isWrapperType()) {
                    Class<?> rawClass = ClassUtils.wrapperToPrimitive(this.retval.getVariableClass());
                    if (!this.retval.getVariableClass().equals(rawClass) && !this.retval.getVariableClass().equals(choice.getVariableClass())) {
                        return false;
                    }
                }
                this.parameter = choice;
                assert (this.isValid());
                return true;
            }
        }
        return false;
    }

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        return null;
    }

    @Override
    public boolean isAssignmentStatement() {
        return true;
    }
}

