/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.lang.reflect.Type;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.NumericalPrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class BytePrimitiveStatement
extends NumericalPrimitiveStatement<Byte> {
    private static final long serialVersionUID = -8123457944460041347L;

    public BytePrimitiveStatement(TestCase tc, Byte value) {
        super(tc, Byte.TYPE, value);
    }

    public BytePrimitiveStatement(TestCase tc) {
        super(tc, Byte.TYPE, Byte.valueOf((byte)0));
    }

    public BytePrimitiveStatement(TestCase tc, Type type) {
        super(tc, type, Byte.valueOf((byte)0));
    }

    @Override
    public void zero() {
        this.value = (byte)0;
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push(((Byte)this.value).shortValue());
    }

    @Override
    public void delta() {
        byte delta = (byte)Math.floor(Randomness.nextGaussian() * (double)Properties.MAX_DELTA);
        this.value = (byte)((Byte)this.value + delta);
    }

    @Override
    public void increment(long delta) {
        this.value = (byte)((long)((Byte)this.value).byteValue() + delta);
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = (byte)(Randomness.nextInt(256) - 128);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = (byte)constantPool.getRandomInt();
        }
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public void setMid(Byte min, Byte max) {
        this.value = (byte)(min + (max - min) / 2);
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public void negate() {
        this.value = -((Byte)this.value).byteValue();
    }
}

