/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.testcase.NumericalPrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class CharPrimitiveStatement
extends NumericalPrimitiveStatement<Character> {
    private static final long serialVersionUID = -1960567565801078784L;

    public CharPrimitiveStatement(TestCase tc, Character value) {
        super(tc, Character.TYPE, value);
    }

    public CharPrimitiveStatement(TestCase tc) {
        super(tc, Character.TYPE, Character.valueOf('\u0000'));
    }

    @Override
    public void zero() {
        this.value = Character.valueOf('\u0000');
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push(((Character)this.value).charValue());
    }

    @Override
    public void delta() {
        int delta = Randomness.nextInt(2 * Properties.MAX_DELTA) - Properties.MAX_DELTA;
        this.value = Character.valueOf((char)(((Character)this.value).charValue() + delta));
    }

    @Override
    public void increment(long delta) {
        this.value = Character.valueOf((char)((long)((Character)this.value).charValue() + delta));
    }

    @Override
    public void randomize() {
        this.value = Character.valueOf(Randomness.nextChar());
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void setMid(Character min, Character max) {
        this.value = Character.valueOf((char)(min.charValue() + (max.charValue() - min.charValue()) / 2));
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public boolean isPositive() {
        return ((Character)this.value).charValue() >= '\u0000';
    }
}

