/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ClassPrimitiveStatement
extends PrimitiveStatement<Class<?>> {
    private static final long serialVersionUID = -2728777640255424791L;
    private transient Set<Class<?>> assignableClasses = new LinkedHashSet();

    public ClassPrimitiveStatement(TestCase tc, GenericClass type, Set<Class<?>> assignableClasses) {
        super(tc, type, Randomness.choice(assignableClasses));
        this.assignableClasses.addAll(assignableClasses);
    }

    public ClassPrimitiveStatement(TestCase tc, Class<?> value) {
        super(tc, new GenericClass(Class.class).getWithParameterTypes(new Type[]{value}), value);
        this.assignableClasses.add(value);
    }

    public ClassPrimitiveStatement(TestCase tc) {
        super(tc, new GenericClass(Class.class).getWithParameterTypes(new Type[]{Properties.getTargetClass()}), Properties.getTargetClass());
    }

    @Override
    public boolean hasMoreThanOneValue() {
        return this.assignableClasses.size() != 1;
    }

    @Override
    public void delta() {
        this.randomize();
    }

    @Override
    public void zero() {
        this.value = Properties.getTargetClass();
    }

    @Override
    protected void pushBytecode(GeneratorAdapter mg) {
    }

    private Class<?> getType(org.objectweb.asm.Type type) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 9: {
                org.objectweb.asm.Type componentType = type.getElementType();
                Class<?> componentClass = this.getType(componentType);
                Class<?> arrayClass = Array.newInstance(componentClass, 0).getClass();
                return arrayClass;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
        }
        return Class.forName(type.getClassName(), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
    }

    @Override
    public void randomize() {
        if (!this.assignableClasses.isEmpty()) {
            this.value = Randomness.choice(this.assignableClasses);
        } else {
            org.objectweb.asm.Type type = ConstantPoolManager.getInstance().getConstantPool().getRandomType();
            try {
                this.value = this.getType(type);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Error loading class " + type.getClassName() + ": " + e);
            }
            catch (NoClassDefFoundError e) {
                logger.warn("Error loading class " + type.getClassName() + ": " + e);
            }
            catch (ExceptionInInitializerError e) {
                logger.warn("Error loading class " + type.getClassName() + ": " + e);
            }
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
        GenericClass genericClass = new GenericClass((Class)this.value);
        genericClass.changeClassLoader(loader);
        this.value = genericClass.getRawClass();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ArrayList<GenericClass> currentAssignableClasses = new ArrayList<GenericClass>();
        for (Class<?> assignableClass : this.assignableClasses) {
            currentAssignableClasses.add(new GenericClass(assignableClass));
        }
        oos.writeObject(currentAssignableClasses);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.value = this.retval.getGenericClass().getRawClass();
        List newAssignableClasses = (List)ois.readObject();
        this.assignableClasses = new LinkedHashSet();
        for (GenericClass assignableClass : newAssignableClasses) {
            this.assignableClasses.add(assignableClass.getRawClass());
        }
    }
}

