/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.ArrayIndex;
import org.evosuite.testcase.ArrayReference;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.FieldReference;
import org.evosuite.testcase.FieldStatement;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.NullReference;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.ListenableList;
import org.evosuite.utils.Listener;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestCase
implements TestCase,
Serializable {
    private static final long serialVersionUID = -689512549778944250L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultTestCase.class);
    private List<String> accessedFiles = new ArrayList<String>();
    protected final ListenableList<StatementInterface> statements;
    private transient Set<TestFitnessFunction> coveredGoals = new LinkedHashSet<TestFitnessFunction>();
    private transient Set<ContractViolation> contractViolations = new LinkedHashSet<ContractViolation>();
    private boolean isFailing = false;
    private boolean unstable = false;

    public DefaultTestCase() {
        this.statements = new ListenableList(new ArrayList());
    }

    @Override
    public void accept(TestVisitor visitor) {
        visitor.visitTestCase(this);
        for (StatementInterface statement : this.statements) {
            logger.trace("Visiting statement " + statement.getCode());
            visitor.visitStatement(statement);
        }
    }

    @Override
    public void addAssertions(TestCase other) {
        for (int i = 0; i < this.statements.size() && i < other.size(); ++i) {
            for (Assertion a : other.getStatement(i).getAssertions()) {
                if (this.statements.get(i).getAssertions().contains(a) || a == null) continue;
                this.statements.get(i).getAssertions().add(a.clone(this));
            }
        }
    }

    @Override
    public void addContractViolation(ContractViolation violation) {
        this.contractViolations.add(violation);
    }

    @Override
    public Set<ContractViolation> getContractViolations() {
        return this.contractViolations;
    }

    @Override
    public void addCoveredGoal(TestFitnessFunction goal) {
        this.coveredGoals.add(goal);
    }

    private void addFields(List<VariableReference> variables, VariableReference var, Type type) {
        if (!var.isPrimitive() && !(var instanceof NullReference)) {
            for (Field field : TestClusterGenerator.getAccessibleFields(var.getVariableClass())) {
                FieldReference f;
                Type fieldType = field.getType();
                try {
                    fieldType = field.getGenericType();
                }
                catch (GenericSignatureFormatError e) {
                    fieldType = field.getType();
                }
                if ((f = new FieldReference(this, new GenericField(field, var.getGenericClass()), fieldType, var)).getDepth() > 2) continue;
                if (type != null) {
                    if (!f.isAssignableTo(type) || variables.contains(f)) continue;
                    variables.add(f);
                    continue;
                }
                if (variables.contains(f)) continue;
                variables.add(f);
            }
        }
    }

    @Override
    public void addListener(Listener<Void> listener) {
        this.statements.addListener(listener);
    }

    @Override
    public VariableReference addStatement(StatementInterface statement) {
        block8: {
            this.statements.add(statement);
            try {
                assert (this.isValid());
            }
            catch (AssertionError e) {
                logger.info("Is not valid: ");
                for (StatementInterface s : this.statements) {
                    try {
                        logger.info(s.getCode());
                    }
                    catch (AssertionError e2) {
                        logger.info("Found error in: " + s);
                        if (!(s instanceof MethodStatement)) continue;
                        MethodStatement ms = (MethodStatement)s;
                        if (!ms.isStatic()) {
                            logger.info("Callee: ");
                            logger.info(ms.callee.toString());
                        }
                        int num = 0;
                        for (VariableReference v : ms.parameters) {
                            logger.info("Parameter " + num);
                            logger.info(v.getVariableClass().toString());
                            logger.info(v.getClass().toString());
                            logger.info(v.toString());
                        }
                    }
                }
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return statement.getReturnValue();
    }

    @Override
    public VariableReference addStatement(StatementInterface statement, int position) {
        this.statements.add(position, statement);
        assert (this.isValid());
        return statement.getReturnValue();
    }

    @Override
    public void addStatements(List<? extends StatementInterface> statements) {
        this.statements.addAll(statements);
    }

    public void changeClassLoader(ClassLoader loader) {
        for (StatementInterface s : this.statements) {
            s.changeClassLoader(loader);
        }
    }

    @Override
    public void chop(int length) {
        while (this.statements.size() > length) {
            this.statements.remove(length);
        }
    }

    @Override
    public void clearCoveredGoals() {
        this.coveredGoals.clear();
    }

    @Override
    public DefaultTestCase clone() {
        DefaultTestCase t = null;
        t = new DefaultTestCase();
        for (StatementInterface s : this.statements) {
            StatementInterface copy = s.clone(t);
            t.statements.add(copy);
            copy.setRetval(s.getReturnValue().clone(t));
            copy.setAssertions(s.copyAssertions(t, 0));
        }
        t.coveredGoals.addAll(this.coveredGoals);
        t.accessedFiles.addAll(this.accessedFiles);
        t.isFailing = this.isFailing;
        return t;
    }

    @Override
    public void deleteListener(Listener<Void> listener) {
        this.statements.deleteListener(listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTestCase other = (DefaultTestCase)obj;
        if (this.statements == null) {
            if (other.statements != null) {
                return false;
            }
        } else {
            if (this.statements.size() != other.statements.size()) {
                return false;
            }
            for (int i = 0; i < this.statements.size(); ++i) {
                if (this.statements.get(i).equals(other.statements.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<Class<?>> getAccessedClasses() {
        LinkedHashSet accessed_classes = new LinkedHashSet();
        for (StatementInterface s : this.statements) {
            for (VariableReference var : s.getVariableReferences()) {
                if (var == null || var.isPrimitive()) continue;
                Class<?> clazz = var.getVariableClass();
                while (clazz.isMemberClass()) {
                    clazz = clazz.getEnclosingClass();
                }
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                accessed_classes.add(clazz);
            }
            if (s instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)s;
                accessed_classes.addAll(Arrays.asList(ms.getMethod().getMethod().getExceptionTypes()));
                accessed_classes.add(ms.getMethod().getMethod().getDeclaringClass());
                accessed_classes.add(ms.getMethod().getMethod().getReturnType());
                accessed_classes.addAll(Arrays.asList(ms.getMethod().getMethod().getParameterTypes()));
                continue;
            }
            if (s instanceof FieldStatement) {
                FieldStatement fs = (FieldStatement)s;
                accessed_classes.add(fs.getField().getField().getDeclaringClass());
                accessed_classes.add(fs.getField().getField().getType());
                continue;
            }
            if (!(s instanceof ConstructorStatement)) continue;
            ConstructorStatement cs = (ConstructorStatement)s;
            accessed_classes.add(cs.getConstructor().getConstructor().getDeclaringClass());
            accessed_classes.addAll(Arrays.asList(cs.getConstructor().getConstructor().getExceptionTypes()));
            accessed_classes.addAll(Arrays.asList(cs.getConstructor().getConstructor().getParameterTypes()));
        }
        return accessed_classes;
    }

    @Override
    public List<String> getAccessedFiles() {
        return this.accessedFiles;
    }

    @Override
    public List<Assertion> getAssertions() {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (StatementInterface s : this.statements) {
            assertions.addAll(s.getAssertions());
        }
        return assertions;
    }

    @Override
    public Set<TestFitnessFunction> getCoveredGoals() {
        return this.coveredGoals;
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        LinkedHashSet exceptions = new LinkedHashSet();
        for (StatementInterface statement : this.statements) {
            exceptions.addAll(statement.getDeclaredExceptions());
        }
        return exceptions;
    }

    @Override
    public Set<VariableReference> getDependencies(VariableReference var) {
        LinkedHashSet<VariableReference> dependencies = new LinkedHashSet<VariableReference>();
        if (var == null || var.getStPosition() == -1) {
            return dependencies;
        }
        LinkedHashSet<StatementInterface> dependentStatements = new LinkedHashSet<StatementInterface>();
        dependentStatements.add(this.statements.get(var.getStPosition()));
        for (int i = var.getStPosition(); i >= 0; --i) {
            LinkedHashSet<StatementInterface> newStatements = new LinkedHashSet<StatementInterface>();
            for (StatementInterface s : dependentStatements) {
                if (!s.references(this.statements.get(i).getReturnValue())) continue;
                newStatements.add(this.statements.get(i));
                dependencies.add(this.statements.get(i).getReturnValue());
                break;
            }
            dependentStatements.addAll(newStatements);
        }
        return dependencies;
    }

    @Override
    public VariableReference getLastObject(Type type) throws ConstructionFailedException {
        return this.getLastObject(type, 0);
    }

    @Override
    public VariableReference getLastObject(Type type, int position) throws ConstructionFailedException {
        for (int i = this.statements.size() - 1; i >= position; --i) {
            StatementInterface statement = this.statements.get(i);
            VariableReference var = statement.getReturnValue();
            if (!var.isAssignableTo(type)) continue;
            return var;
        }
        throw new ConstructionFailedException("Foudn no variables of type " + type);
    }

    @Override
    public Object getObject(VariableReference reference, Scope scope) {
        try {
            return reference.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new AssertionError((Object)"This case isn't handled yet");
        }
    }

    @Override
    public List<VariableReference> getObjects(int position) {
        LinkedList<VariableReference> variables = new LinkedList<VariableReference>();
        for (int i = 0; i < position && i < this.statements.size(); ++i) {
            VariableReference value = this.statements.get(i).getReturnValue();
            if (value == null) continue;
            if (value instanceof ArrayReference) {
                for (int index = 0; index < ((ArrayReference)value).getArrayLength(); ++index) {
                    variables.add(new ArrayIndex((TestCase)this, (ArrayReference)value, index));
                }
                continue;
            }
            if (value instanceof ArrayIndex) continue;
            variables.add(value);
            this.addFields(variables, value, null);
        }
        return variables;
    }

    @Override
    public List<VariableReference> getObjects(Type type, int position) {
        LinkedList<VariableReference> variables = new LinkedList<VariableReference>();
        for (int i = 0; i < position && i < this.size(); ++i) {
            VariableReference value = this.statements.get(i).getReturnValue();
            if (value == null) continue;
            if (value instanceof ArrayReference) {
                Class<?> arrayClass;
                boolean isClassUtilsBug = false;
                Class<?> rawClass = GenericTypeReflector.erase(type);
                if (value.isArray()) {
                    arrayClass = value.getVariableClass();
                    isClassUtilsBug = this.isClassUtilsBug(rawClass, arrayClass);
                }
                if (rawClass.isArray() && !isClassUtilsBug) {
                    isClassUtilsBug = this.isClassUtilsBug(value.getVariableClass(), rawClass);
                }
                if (value.isAssignableTo(type) && !isClassUtilsBug) {
                    logger.debug("Array is assignable: " + value.getType() + " to " + type + ", " + value.isArray() + ", " + rawClass.isArray());
                    variables.add(value);
                    continue;
                }
                if (!GenericClass.isAssignable(type, value.getComponentType()) || this.isClassUtilsBug(rawClass, arrayClass = value.getComponentClass())) continue;
                for (int index = 0; index < ((ArrayReference)value).getArrayLength(); ++index) {
                    if (!((ArrayReference)value).isInitialized(index, position)) continue;
                    variables.add(new ArrayIndex((TestCase)this, (ArrayReference)value, index));
                }
                continue;
            }
            if (value instanceof ArrayIndex) continue;
            if (value.isAssignableTo(type)) {
                variables.add(value);
                continue;
            }
            this.addFields(variables, value, type);
        }
        return variables;
    }

    @Override
    public VariableReference getRandomNonNullNonPrimitiveObject(Type type, int position) throws ConstructionFailedException {
        assert (type != null);
        List<VariableReference> variables = this.getObjects(type, position);
        Iterator<VariableReference> iterator = variables.iterator();
        while (iterator.hasNext()) {
            VariableReference var = iterator.next();
            if (var instanceof NullReference) {
                iterator.remove();
                continue;
            }
            if (this.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                iterator.remove();
                continue;
            }
            if (!var.isPrimitive() && !var.isWrapperType()) continue;
            iterator.remove();
        }
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomNonNullObject(Type type, int position) throws ConstructionFailedException {
        assert (type != null);
        List<VariableReference> variables = this.getObjects(type, position);
        Iterator<VariableReference> iterator = variables.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof NullReference)) continue;
            iterator.remove();
        }
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomObject() {
        return this.getRandomObject(this.statements.size());
    }

    @Override
    public VariableReference getRandomObject(int position) {
        List<VariableReference> variables = this.getObjects(position);
        if (variables.isEmpty()) {
            return null;
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomObject(Type type) throws ConstructionFailedException {
        return this.getRandomObject(type, this.statements.size());
    }

    @Override
    public VariableReference getRandomObject(Type type, int position) throws ConstructionFailedException {
        assert (type != null);
        List<VariableReference> variables = this.getObjects(type, position);
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public Set<VariableReference> getReferences(VariableReference var) {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        if (var == null || var.getStPosition() == -1) {
            return references;
        }
        for (int i = var.getStPosition() + 1; i < this.statements.size(); ++i) {
            LinkedHashSet<VariableReference> temp = new LinkedHashSet<VariableReference>();
            if (this.statements.get(i).references(var)) {
                temp.add(this.statements.get(i).getReturnValue());
            }
            for (VariableReference v : references) {
                if (!this.statements.get(i).references(v)) continue;
                temp.add(this.statements.get(i).getReturnValue());
            }
            references.addAll(temp);
        }
        return references;
    }

    @Override
    public VariableReference getReturnValue(int position) {
        return this.statements.get(position).getReturnValue();
    }

    @Override
    public StatementInterface getStatement(int position) {
        return this.statements.get(position);
    }

    @Override
    public boolean hasAssertions() {
        for (StatementInterface s : this.statements) {
            if (!s.hasAssertions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCastableObject(Type type) {
        for (StatementInterface st : this.statements) {
            if (!st.getReturnValue().isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.statements.hashCode();
    }

    @Override
    public boolean hasObject(Type type, int position) {
        for (int i = 0; i < position; ++i) {
            StatementInterface st = this.statements.get(i);
            if (st.getReturnValue() == null || !st.getReturnValue().isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReferences(VariableReference var) {
        if (var == null || var.getStPosition() == -1) {
            return false;
        }
        for (int i = var.getStPosition() + 1; i < this.statements.size(); ++i) {
            if (!this.statements.get(i).references(var)) continue;
            return true;
        }
        for (Assertion assertion : this.statements.get(var.getStPosition()).getAssertions()) {
            if (!assertion.getReferencedVariables().contains(var)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassUtilsBug(Class<?> rawClass, Class<?> arrayClass) {
        while (arrayClass != null && arrayClass.isArray()) {
            if (rawClass.isAssignableFrom(arrayClass.getComponentType())) {
                return true;
            }
            arrayClass = arrayClass.getComponentType();
        }
        return false;
    }

    @Override
    public boolean isAccessible() {
        for (StatementInterface statement : this.statements) {
            if (statement.isAccessible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public boolean isPrefix(TestCase t) {
        if (this.statements.size() > t.size()) {
            return false;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i).same(t.getStatement(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnstable() {
        return this.unstable;
    }

    @Override
    public boolean isValid() {
        for (StatementInterface s : this.statements) {
            assert (s.isValid()) : this.toCode();
        }
        return true;
    }

    @Override
    public Iterator<StatementInterface> iterator() {
        return this.statements.iterator();
    }

    @Override
    public void remove(int position) {
        logger.debug("Removing statement " + position);
        if (position >= this.size()) {
            return;
        }
        this.statements.remove(position);
        assert (this.isValid());
    }

    @Override
    public void removeAssertion(Assertion assertion) {
        for (StatementInterface s : this.statements) {
            s.removeAssertion(assertion);
        }
    }

    @Override
    public void removeAssertions() {
        for (StatementInterface s : this.statements) {
            s.removeAssertions();
        }
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        for (StatementInterface statement : this.statements) {
            statement.replace(var1, var2);
        }
    }

    @Override
    public void setAccessedFiles(List<String> files) {
        this.accessedFiles = files;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.coveredGoals = new LinkedHashSet<TestFitnessFunction>();
        this.contractViolations = new LinkedHashSet<ContractViolation>();
    }

    public void setFailing(boolean failing) {
        this.isFailing = failing;
    }

    @Override
    public VariableReference setStatement(StatementInterface statement, int position) {
        this.statements.set(position, statement);
        assert (this.isValid());
        return statement.getReturnValue();
    }

    @Override
    public void setUnstable(boolean unstable) {
        this.unstable = unstable;
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public String toCode() {
        TestCodeVisitor visitor = new TestCodeVisitor();
        this.accept(visitor);
        return visitor.getCode();
    }

    @Override
    public String toCode(Map<Integer, Throwable> exceptions) {
        TestCodeVisitor visitor = new TestCodeVisitor();
        visitor.setExceptions(exceptions);
        this.accept(visitor);
        return visitor.getCode();
    }

    public String toString() {
        return this.toCode();
    }
}

