/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationExecutionResult;
import org.evosuite.ga.Chromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public abstract class ExecutableChromosome
extends Chromosome {
    private static final long serialVersionUID = 1L;
    protected transient ExecutionResult lastExecutionResult = null;
    protected transient Map<Mutation, MutationExecutionResult> lastMutationResult = new HashMap<Mutation, MutationExecutionResult>();

    public void setLastExecutionResult(ExecutionResult lastExecutionResult) {
        this.lastExecutionResult = lastExecutionResult;
    }

    public ExecutionResult getLastExecutionResult() {
        return this.lastExecutionResult;
    }

    public void setLastExecutionResult(MutationExecutionResult lastExecutionResult, Mutation mutation) {
        this.lastMutationResult.put(mutation, lastExecutionResult);
    }

    public MutationExecutionResult getLastExecutionResult(Mutation mutation) {
        return this.lastMutationResult.get(mutation);
    }

    public void clearCachedResults() {
        this.lastExecutionResult = null;
        this.lastMutationResult.clear();
    }

    public void clearCachedMutationResults() {
        this.lastMutationResult.clear();
    }

    protected abstract void copyCachedResults(ExecutableChromosome var1);

    public abstract ExecutionResult executeForFitnessFunction(TestSuiteFitnessFunction var1);

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.lastExecutionResult = null;
        this.lastMutationResult = new HashMap<Mutation, MutationExecutionResult>();
    }
}

