/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.VariableReference;

public abstract class ExecutionObserver {
    protected static TestCase currentTest = null;
    protected static final Set<Class<?>> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class));

    protected static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    public static void setCurrentTest(TestCase test) {
        currentTest = test;
    }

    public static TestCase getCurrentTest() {
        return currentTest;
    }

    public abstract void output(int var1, String var2);

    public abstract void beforeStatement(StatementInterface var1, Scope var2);

    public abstract void afterStatement(StatementInterface var1, Scope var2, Throwable var3);

    public abstract void testExecutionFinished(ExecutionResult var1);

    public abstract void clear();

    protected Set<VariableReference> getDependentVariables(StatementInterface statement) {
        HashSet<VariableReference> dependencies = new HashSet<VariableReference>();
        for (VariableReference var : statement.getVariableReferences()) {
            dependencies.add(var);
            dependencies.addAll(currentTest.getDependencies(var));
        }
        return dependencies;
    }
}

