/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.EvosuiteError;
import org.evosuite.testcase.ExecutionTrace;
import org.evosuite.testcase.ExecutionTraceImpl;
import org.evosuite.testcase.ExecutionTraceProxy;
import org.evosuite.testcase.TestCaseExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTracer {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionTracer.class);
    private static ExecutionTracer instance = null;
    private boolean disabled = true;
    private boolean killSwitch = false;
    private int num_statements = 0;
    private ExecutionTrace trace = new ExecutionTraceProxy();
    private static boolean checkCallerThread = true;
    private static Thread currentThread = null;

    public static void setThread(Thread thread) {
        currentThread = thread;
    }

    public static void disable() {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        tracer.disabled = true;
    }

    public static void enable() {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        tracer.disabled = false;
    }

    public static boolean isEnabled() {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        return !tracer.disabled;
    }

    public static void setKillSwitch(boolean value) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        tracer.killSwitch = value;
    }

    public static void setCheckCallerThread(boolean checkCallerThread) {
        ExecutionTracer.checkCallerThread = checkCallerThread;
    }

    public static void disableTraceCalls() {
        ExecutionTraceImpl.disableTraceCalls();
    }

    public static void enableTraceCalls() {
        ExecutionTraceImpl.enableTraceCalls();
    }

    public static boolean isTraceCallsEnabled() {
        return ExecutionTraceImpl.isTraceCallsEnabled();
    }

    public static ExecutionTracer getExecutionTracer() {
        if (instance == null) {
            instance = new ExecutionTracer();
        }
        return instance;
    }

    public void clear() {
        this.trace = new ExecutionTraceProxy();
        BooleanHelper.clearStack();
        this.num_statements = 0;
    }

    public static boolean isThreadNeqCurrentThread() {
        if (!checkCallerThread) {
            return false;
        }
        if (currentThread == null) {
            logger.info("CurrentThread has not been set!");
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Thread t : map.keySet()) {
                String msg = "Thread: " + t + "\n";
                for (StackTraceElement e : map.get(t)) {
                    msg = msg + " -> " + e + "\n";
                }
                logger.error(msg);
            }
            currentThread = Thread.currentThread();
        }
        return Thread.currentThread() != currentThread;
    }

    public ExecutionTrace getTrace() {
        this.trace.finishCalls();
        return this.trace;
    }

    public Throwable getLastException() {
        return this.trace.getExplicitException();
    }

    public static void enteredMethod(String classname, String methodname, Object caller) throws TestCaseExecutor.TimeoutExceeded {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        tracer.trace.enteredMethod(classname, methodname, caller);
    }

    public static void returnValue(int value, String className, String methodName) {
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        tracer.trace.returnValue(className, methodName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnValue(Object value, String className, String methodName) {
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        if (!ExecutionTracer.isEnabled()) {
            return;
        }
        if (value == null) {
            ExecutionTracer.returnValue(0, className, methodName);
            return;
        }
        StringBuilder tmp = null;
        try {
            ExecutionTracer.disable();
            tmp = new StringBuilder(value.toString());
        }
        catch (Throwable t) {
            return;
        }
        finally {
            ExecutionTracer.enable();
        }
        int index = 0;
        int position = 0;
        boolean found = false;
        boolean deleteAddresses = true;
        int c = 32;
        while ((position = tmp.indexOf("@", index)) > 0) {
            for (index = position + 1; index < position + 17 && index < tmp.length() && ((c = (int)tmp.charAt(index)) >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70); ++index) {
                found = true;
            }
            if (!deleteAddresses || !found) continue;
            tmp.delete(position + 1, index);
        }
        ExecutionTracer.returnValue(tmp.toString().hashCode(), className, methodName);
    }

    public static void leftMethod(String classname, String methodname) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        tracer.trace.exitMethod(classname, methodname);
    }

    public static void checkTimeout() {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (tracer.killSwitch && !ExecutionTracer.isInStaticInit()) {
            throw new TestCaseExecutor.TimeoutExceeded();
        }
    }

    private static boolean isInStaticInit() {
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            if (!elem.getMethodName().equals("<clinit>")) continue;
            return true;
        }
        return false;
    }

    public static void passedLine(String className, String methodName, int line) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        tracer.trace.linePassed(className, methodName, line);
    }

    public static void passedUnconditionalBranch(int opcode, int branch, int bytecode_id) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        tracer.trace.branchPassed(branch, bytecode_id, 0.0, 0.0);
    }

    public static void passedBranch(int val, int opcode, int branch, int bytecode_id) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        if (Properties.DYNAMIC_SEEDING) {
            ConstantPoolManager.getInstance().addDynamicConstant(val);
        }
        double distance_true = 0.0;
        double distance_false = 0.0;
        switch (opcode) {
            case 153: {
                distance_true = Math.abs((double)val);
                distance_false = distance_true == 0.0 ? 1.0 : 0.0;
                break;
            }
            case 154: {
                distance_false = Math.abs((double)val);
                distance_true = distance_false == 0.0 ? 1.0 : 0.0;
                break;
            }
            case 155: {
                distance_true = val >= 0 ? (double)val + 1.0 : 0.0;
                distance_false = val < 0 ? 0.0 - (double)val + 1.0 : 0.0;
                break;
            }
            case 157: {
                distance_true = val <= 0 ? 0.0 - (double)val + 1.0 : 0.0;
                distance_false = val > 0 ? (double)val + 1.0 : 0.0;
                break;
            }
            case 156: {
                distance_true = val < 0 ? 0.0 - (double)val + 1.0 : 0.0;
                distance_false = val >= 0 ? (double)val + 1.0 : 0.0;
                break;
            }
            case 158: {
                distance_true = val > 0 ? (double)val + 1.0 : 0.0;
                distance_false = val <= 0 ? 0.0 - (double)val + 1.0 : 0.0;
                break;
            }
            default: {
                logger.error("Unknown opcode: " + opcode);
            }
        }
        tracer.trace.branchPassed(branch, bytecode_id, distance_true, distance_false);
    }

    public static void passedPutStatic(String classNameWithDots, String fieldName) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        tracer.trace.putStaticPassed(classNameWithDots, fieldName);
    }

    public static void passedBranch(int val1, int val2, int opcode, int branch, int bytecode_id) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        if (Properties.DYNAMIC_SEEDING) {
            ConstantPoolManager.getInstance().addDynamicConstant(val1);
            ConstantPoolManager.getInstance().addDynamicConstant(val2);
        }
        double distance_true = 0.0;
        double distance_false = 0.0;
        switch (opcode) {
            case 159: {
                distance_true = Math.abs((double)val1 - (double)val2);
                distance_false = distance_true == 0.0 ? 1.0 : 0.0;
                break;
            }
            case 160: {
                distance_false = Math.abs((double)val1 - (double)val2);
                distance_true = distance_false == 0.0 ? 1.0 : 0.0;
                break;
            }
            case 161: {
                distance_true = val1 >= val2 ? (double)val1 - (double)val2 + 1.0 : 0.0;
                distance_false = val1 < val2 ? (double)val2 - (double)val1 + 1.0 : 0.0;
                break;
            }
            case 162: {
                distance_true = val1 < val2 ? (double)val2 - (double)val1 + 1.0 : 0.0;
                distance_false = val1 >= val2 ? (double)val1 - (double)val2 + 1.0 : 0.0;
                break;
            }
            case 163: {
                distance_true = val1 <= val2 ? (double)val2 - (double)val1 + 1.0 : 0.0;
                distance_false = val1 > val2 ? (double)val1 - (double)val2 + 1.0 : 0.0;
                break;
            }
            case 164: {
                distance_true = val1 > val2 ? (double)val1 - (double)val2 + 1.0 : 0.0;
                distance_false = val1 <= val2 ? (double)val2 - (double)val1 + 1.0 : 0.0;
                break;
            }
            default: {
                logger.error("Unknown opcode: " + opcode);
            }
        }
        tracer.trace.branchPassed(branch, bytecode_id, distance_true, distance_false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void passedBranch(Object val1, Object val2, int opcode, int branch, int bytecode_id) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        double distance_true = 0.0;
        double distance_false = 0.0;
        switch (opcode) {
            case 165: {
                if (val1 == null) {
                    distance_true = val2 == null ? 0.0 : 1.0;
                    break;
                }
                ExecutionTracer.disable();
                try {
                    distance_true = val1.equals(val2) ? 0.0 : 1.0;
                    break;
                }
                catch (Throwable t) {
                    logger.debug("Equality raised exception: " + t);
                    distance_true = 1.0;
                    break;
                }
                finally {
                    ExecutionTracer.enable();
                }
            }
            case 166: {
                if (val1 == null) {
                    distance_true = val2 == null ? 1.0 : 0.0;
                    break;
                }
                ExecutionTracer.disable();
                try {
                    distance_true = val1.equals(val2) ? 1.0 : 0.0;
                    break;
                }
                catch (Exception e) {
                    logger.debug("Caught exception during comparison: " + e);
                    distance_true = 1.0;
                    break;
                }
                finally {
                    ExecutionTracer.enable();
                }
            }
        }
        distance_false = distance_true == 0.0 ? 1.0 : 0.0;
        tracer.trace.branchPassed(branch, bytecode_id, distance_true, distance_false);
    }

    public static void passedBranch(Object val, int opcode, int branch, int bytecode_id) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        double distance_true = 0.0;
        double distance_false = 0.0;
        switch (opcode) {
            case 198: {
                distance_true = val == null ? 0.0 : 1.0;
                break;
            }
            case 199: {
                distance_true = val == null ? 1.0 : 0.0;
                break;
            }
            default: {
                logger.error("Warning: encountered opcode " + opcode);
            }
        }
        distance_false = distance_true == 0.0 ? 1.0 : 0.0;
        tracer.trace.branchPassed(branch, bytecode_id, distance_true, distance_false);
    }

    public static void passedDefinition(Object object, Object caller, int defID) {
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (!tracer.disabled) {
            tracer.trace.definitionPassed(object, caller, defID);
        }
    }

    public static void passedUse(Object object, Object caller, int useID) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        tracer.trace.usePassed(object, caller, useID);
    }

    public static void passedFieldMethodCall(Object callee, Object caller, int defuseId) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        if (DefUsePool.isKnownAsDefinition(defuseId)) {
            Definition passedDef = DefUsePool.getDefinitionByDefUseId(defuseId);
            ExecutionTracer.passedDefinition(callee, caller, passedDef.getDefId());
        } else if (DefUsePool.isKnownAsUse(defuseId)) {
            Use passedUse = DefUsePool.getUseByDefUseId(defuseId);
            ExecutionTracer.passedUse(callee, caller, passedUse.getUseId());
        } else {
            throw new EvosuiteError("instrumentation called passedFieldMethodCall with invalid defuseId: " + defuseId + ", known IDs: " + DefUsePool.getDefUseCounter());
        }
    }

    public static void passedMutation(double distance, int mutationId) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        tracer.trace.mutationPassed(mutationId, distance);
    }

    public static void exceptionThrown(Object exception, String className, String methodName) {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        tracer.trace.setExplicitException((Throwable)exception);
    }

    public static void statementExecuted() {
        ExecutionTracer tracer = ExecutionTracer.getExecutionTracer();
        if (tracer.disabled) {
            return;
        }
        if (ExecutionTracer.isThreadNeqCurrentThread()) {
            return;
        }
        ExecutionTracer.checkTimeout();
        ++tracer.num_statements;
    }

    public int getNumStatementsExecuted() {
        return this.num_statements;
    }

    private ExecutionTracer() {
    }
}

