/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.testcase.AbstractStatement;
import org.evosuite.testcase.ArrayReference;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.EvosuiteError;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.VariableReference;
import org.evosuite.testcase.VariableReferenceImpl;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class FieldStatement
extends AbstractStatement {
    private static final long serialVersionUID = -4944610139232763790L;
    protected GenericField field;
    protected VariableReference source;

    public FieldStatement(TestCase tc, GenericField field, VariableReference source) {
        super(tc, new VariableReferenceImpl(tc, field.getFieldType()));
        this.field = field;
        this.source = source;
        if (this.retval.getComponentType() != null) {
            this.retval = new ArrayReference(tc, this.retval.getGenericClass(), 0);
        }
    }

    public FieldStatement(TestCase tc, GenericField field, VariableReference source, VariableReference ret_var) {
        super(tc, ret_var);
        assert (tc.size() > ret_var.getStPosition());
        this.field = field;
        this.source = source;
    }

    public VariableReference getSource() {
        return this.source;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        if (Randomness.nextDouble() >= Properties.P_CHANGE_PARAMETER) {
            return false;
        }
        if (!this.isStatic()) {
            VariableReference source = this.getSource();
            List<VariableReference> objects = test.getObjects(source.getType(), this.getPosition());
            objects.remove(source);
            if (!objects.isEmpty()) {
                this.setSource(Randomness.choice(objects));
                return true;
            }
        }
        return false;
    }

    public void setSource(VariableReference source) {
        this.source = source;
    }

    @Override
    public boolean isAccessible() {
        if (!this.field.isAccessible()) {
            return false;
        }
        return super.isAccessible();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public int getNumParameters() {
        if (this.isStatic()) {
            return 0;
        }
        return 1;
    }

    @Override
    public StatementInterface copy(TestCase newTestCase, int offset) {
        if (this.field.isStatic()) {
            FieldStatement s = new FieldStatement(newTestCase, this.field.copy(), null);
            return s;
        }
        VariableReference newSource = this.source.copy(newTestCase, offset);
        FieldStatement s = new FieldStatement(newTestCase, this.field.copy(), newSource);
        return s;
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Object source_object;
                    try {
                        Object object = source_object = FieldStatement.this.field.isStatic() ? null : FieldStatement.this.source.getObject(scope);
                        if (!FieldStatement.this.field.isStatic() && source_object == null) {
                            FieldStatement.this.retval.setObject(scope, null);
                            throw new CodeUnderTestException(new NullPointerException());
                        }
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                    Object ret = FieldStatement.this.field.getField().get(source_object);
                    if (!FieldStatement.this.retval.isAssignableFrom(ret.getClass())) {
                        throw new CodeUnderTestException(new ClassCastException());
                    }
                    try {
                        FieldStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    HashSet<Class<? extends Throwable>> t = new HashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            exceptionThrown = e.getCause();
            return exceptionThrown;
        }
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        if (!this.isStatic()) {
            references.add(this.source);
            if (this.source.getAdditionalVariableReference() != null) {
                references.add(this.source.getAdditionalVariableReference());
            }
        }
        return references;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (!this.field.isStatic()) {
            if (this.source.equals(var1)) {
                this.source = var2;
            } else {
                this.source.replaceAdditionalVariableReference(var1, var2);
            }
        }
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        FieldStatement fs = (FieldStatement)s;
        if (!this.field.isStatic()) {
            return this.source.equals(fs.source) && this.retval.equals(fs.retval) && this.field.equals(fs.field);
        }
        return this.retval.equals(fs.retval) && this.field.equals(fs.field);
    }

    @Override
    public int hashCode() {
        int prime = 51;
        int result = 1;
        result = 51 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 51 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public GenericField getField() {
        return this.field;
    }

    public void setField(GenericField field) {
        this.field = field;
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        Label start = mg.newLabel();
        Label end = mg.newLabel();
        mg.mark(start);
        if (!this.isStatic()) {
            this.source.loadBytecode(mg, locals);
        }
        if (this.isStatic()) {
            mg.getStatic(Type.getType(this.field.getField().getDeclaringClass()), this.field.getName(), Type.getType(this.field.getField().getType()));
        } else if (!this.source.getVariableClass().isInterface()) {
            mg.getField(Type.getType(this.source.getVariableClass()), this.field.getName(), Type.getType(this.field.getField().getType()));
        } else {
            mg.getField(Type.getType(this.field.getField().getDeclaringClass()), this.field.getName(), Type.getType(this.field.getField().getType()));
        }
        if (!this.retval.getVariableClass().equals(this.field.getField().getType())) {
            if (!this.retval.getVariableClass().isPrimitive()) {
                if (this.field.getField().getType().isPrimitive()) {
                    mg.box(Type.getType(this.field.getField().getType()));
                }
                mg.checkCast(Type.getType(this.retval.getVariableClass()));
            } else {
                mg.cast(Type.getType(this.field.getField().getType()), Type.getType(this.retval.getVariableClass()));
            }
        }
        this.retval.storeBytecode(mg, locals);
        mg.mark(end);
        Label l = mg.newLabel();
        mg.goTo(l);
        mg.catchException(start, end, Type.getType(Throwable.class));
        mg.pop();
        if (!this.retval.isVoid()) {
            Class<?> clazz = this.retval.getVariableClass();
            if (clazz.equals(Boolean.TYPE)) {
                mg.push(false);
            } else if (clazz.equals(Character.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Integer.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Short.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Long.TYPE)) {
                mg.push(0L);
            } else if (clazz.equals(Float.TYPE)) {
                mg.push(0.0f);
            } else if (clazz.equals(Double.TYPE)) {
                mg.push(0.0);
            } else if (clazz.equals(Byte.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(String.class)) {
                mg.push("");
            } else {
                mg.visitInsn(1);
            }
            this.retval.storeBytecode(mg, locals);
        }
        mg.mark(l);
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        return new ArrayList<VariableReference>(this.getVariableReferences());
    }

    @Override
    public boolean same(StatementInterface s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        FieldStatement fs = (FieldStatement)s;
        if (!this.field.isStatic()) {
            return this.source.same(fs.source) && this.retval.same(fs.retval) && this.field.equals(fs.field);
        }
        return this.retval.same(fs.retval) && this.field.equals(fs.field);
    }

    public GenericField getAccessibleObject() {
        return this.field;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.field.changeClassLoader(loader);
        super.changeClassLoader(loader);
    }
}

