/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.NumericalPrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class FloatPrimitiveStatement
extends NumericalPrimitiveStatement<Float> {
    private static final long serialVersionUID = 708022695544843828L;

    public FloatPrimitiveStatement(TestCase tc, Float value) {
        super(tc, Float.TYPE, value);
    }

    public FloatPrimitiveStatement(TestCase tc) {
        super(tc, Float.TYPE, Float.valueOf(0.0f));
    }

    @Override
    public void zero() {
        this.value = new Float(0.0);
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push(((Float)this.value).floatValue());
    }

    @Override
    public void delta() {
        double P = Randomness.nextDouble();
        if (P < 0.3333333333333333) {
            this.value = Float.valueOf(((Float)this.value).floatValue() + (float)Randomness.nextGaussian() * (float)Properties.MAX_DELTA);
        } else if (P < 0.6666666666666666) {
            this.value = Float.valueOf(((Float)this.value).floatValue() + (float)Randomness.nextGaussian());
        } else {
            int precision = Randomness.nextInt(7);
            this.chopPrecision(precision);
        }
    }

    private void chopPrecision(int precision) {
        if (((Float)this.value).isNaN() || ((Float)this.value).isInfinite()) {
            return;
        }
        BigDecimal bd = new BigDecimal(((Float)this.value).floatValue()).setScale(precision, RoundingMode.HALF_EVEN);
        this.value = Float.valueOf(bd.floatValue());
    }

    @Override
    public void increment(long delta) {
        this.value = Float.valueOf(((Float)this.value).floatValue() + (float)delta);
    }

    @Override
    public void increment(double delta) {
        this.value = Float.valueOf(((Float)this.value).floatValue() + (float)delta);
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = Float.valueOf((float)(Randomness.nextGaussian() * (double)Properties.MAX_INT));
            int precision = Randomness.nextInt(7);
            this.chopPrecision(precision);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = Float.valueOf(constantPool.getRandomFloat());
        }
    }

    @Override
    public void increment() {
        this.increment(1.0);
    }

    @Override
    public void setMid(Float min, Float max) {
        this.value = Float.valueOf(min.floatValue() + (max.floatValue() - min.floatValue()) / 2.0f);
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public boolean isPositive() {
        return ((Float)this.value).floatValue() > 0.0f;
    }

    @Override
    public void negate() {
        this.value = Float.valueOf(-((Float)this.value).floatValue());
    }
}

