/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.NumericalPrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class LongPrimitiveStatement
extends NumericalPrimitiveStatement<Long> {
    private static final long serialVersionUID = 6902273233816031053L;

    public LongPrimitiveStatement(TestCase tc, Long value) {
        super(tc, Long.TYPE, value);
    }

    public LongPrimitiveStatement(TestCase tc) {
        super(tc, Long.TYPE, Long.valueOf(0L));
    }

    @Override
    public void zero() {
        this.value = new Long(0L);
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push((Long)this.value);
    }

    @Override
    public void delta() {
        long delta = (long)Math.floor(Randomness.nextGaussian() * (double)Properties.MAX_DELTA);
        this.value = (Long)this.value + delta;
    }

    @Override
    public void increment(long delta) {
        this.value = (Long)this.value + delta;
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = (long)(Randomness.nextGaussian() * (double)Properties.MAX_INT);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = constantPool.getRandomLong();
        }
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void setMid(Long min, Long max) {
        this.value = min + (max - min) / 2L;
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public boolean isPositive() {
        return (Long)this.value >= 0L;
    }

    @Override
    public void negate() {
        this.value = -((Long)this.value).longValue();
    }
}

