/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.List;

public class MethodCall
implements Cloneable {
    public String className;
    public String methodName;
    public List<Integer> lineTrace;
    public List<Integer> branchTrace;
    public List<Double> trueDistanceTrace;
    public List<Double> falseDistanceTrace;
    public List<Integer> defuseCounterTrace;
    public int methodId;
    public int callingObjectID;
    public int callDepth;

    public MethodCall(String className, String methodName, int methodId, int callingObjectID, int callDepth) {
        this.className = className;
        this.methodName = methodName;
        this.lineTrace = new ArrayList<Integer>();
        this.branchTrace = new ArrayList<Integer>();
        this.trueDistanceTrace = new ArrayList<Double>();
        this.falseDistanceTrace = new ArrayList<Double>();
        this.defuseCounterTrace = new ArrayList<Integer>();
        this.methodId = methodId;
        this.callingObjectID = callingObjectID;
        this.callDepth = callDepth;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.className);
        ret.append(":");
        ret.append(this.methodName);
        ret.append("\n");
        ret.append("Branches: ");
        for (Integer branch : this.branchTrace) {
            ret.append(" " + branch);
        }
        ret.append("\n");
        ret.append("True Distances: ");
        for (Double distance : this.trueDistanceTrace) {
            ret.append(" " + distance);
        }
        ret.append("\nFalse Distances: ");
        for (Double distance : this.falseDistanceTrace) {
            ret.append(" " + distance);
        }
        ret.append("\n");
        return ret.toString();
    }

    public String explain() {
        StringBuffer r = new StringBuffer();
        r.append(this.className);
        r.append(":");
        r.append(this.methodName);
        r.append("\n");
        r.append("Lines: ");
        if (this.lineTrace == null) {
            r.append("null");
        } else {
            for (Integer line : this.lineTrace) {
                r.append("\t" + line);
            }
            r.append("\n");
        }
        r.append("Branches: ");
        if (this.branchTrace == null) {
            r.append("null");
        } else {
            for (Integer branch : this.branchTrace) {
                r.append("\t" + branch);
            }
            r.append("\n");
        }
        r.append("True Distances: ");
        if (this.trueDistanceTrace == null) {
            r.append("null");
        } else {
            for (Double distance : this.trueDistanceTrace) {
                r.append("\t" + distance);
            }
            r.append("\n");
        }
        r.append("False Distances: ");
        if (this.falseDistanceTrace == null) {
            r.append("null");
        } else {
            for (Double distance : this.falseDistanceTrace) {
                r.append("\t" + distance);
            }
            r.append("\n");
        }
        r.append("DefUse Trace:");
        if (this.defuseCounterTrace == null) {
            r.append("null");
        } else {
            for (Integer duCounter : this.defuseCounterTrace) {
                r.append("\t" + duCounter);
            }
            r.append("\n");
        }
        return r.toString();
    }

    public MethodCall clone() {
        MethodCall copy = new MethodCall(this.className, this.methodName, this.methodId, this.callingObjectID, this.callDepth);
        copy.lineTrace = new ArrayList<Integer>(this.lineTrace);
        copy.branchTrace = new ArrayList<Integer>(this.branchTrace);
        copy.trueDistanceTrace = new ArrayList<Double>(this.trueDistanceTrace);
        copy.falseDistanceTrace = new ArrayList<Double>(this.falseDistanceTrace);
        copy.defuseCounterTrace = new ArrayList<Integer>(this.defuseCounterTrace);
        return copy;
    }
}

