/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.Properties;
import org.evosuite.testcase.AbstractStatement;
import org.evosuite.testcase.ArrayIndex;
import org.evosuite.testcase.ArrayReference;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.EvosuiteError;
import org.evosuite.testcase.NullStatement;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.UncompilableCodeException;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class MethodStatement
extends AbstractStatement {
    private static final long serialVersionUID = 6134126797102983073L;
    protected GenericMethod method;
    protected VariableReference callee;
    protected List<VariableReference> parameters;

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, List<VariableReference> parameters) throws IllegalArgumentException {
        super(tc, method.getReturnType());
        this.init(method, callee, parameters);
    }

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, List<VariableReference> parameters, VariableReference retVal) throws IllegalArgumentException {
        this(tc, method, callee, parameters);
        this.retval = retVal;
    }

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, VariableReference retvar, List<VariableReference> parameters) {
        super(tc, retvar);
        if (retvar.getStPosition() >= tc.size()) {
            throw new IllegalArgumentException("Cannot replace in position " + retvar.getStPosition() + " when the test case has only " + tc.size() + " elements");
        }
        this.init(method, callee, parameters);
    }

    private void init(GenericMethod method, VariableReference callee, List<VariableReference> parameters) throws IllegalArgumentException {
        if (callee == null && !method.isStatic()) {
            throw new IllegalArgumentException("A null callee cannot call a non-static method");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter list cannot be null");
        }
        for (VariableReference var : parameters) {
            if (var != null) continue;
            throw new IllegalArgumentException("Parameter list cannot have null parameters (this is different from a NullReference)");
        }
        if (method.getParameterTypes().length != parameters.size()) {
            throw new IllegalArgumentException("Parameters list mismatch from the types declared in the method: " + method.getParameterTypes().length + " != " + parameters.size());
        }
        this.method = method;
        this.callee = this.isStatic() ? null : callee;
        this.parameters = parameters;
    }

    public GenericMethod getMethod() {
        return this.method;
    }

    public void setMethod(GenericMethod method) {
        this.method = method;
    }

    public VariableReference getCallee() {
        return this.callee;
    }

    public void setCallee(VariableReference callee) {
        if (!this.isStatic()) {
            this.callee = callee;
        }
    }

    public boolean isStatic() {
        return this.method.isStatic();
    }

    private boolean isInstanceMethod() {
        return !this.method.isStatic();
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        logger.trace("Executing method " + this.method.getName());
        final Object[] inputs = new Object[this.parameters.size()];
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Class returnClass;
                    Object callee_object;
                    try {
                        Type[] parameterTypes = MethodStatement.this.method.getParameterTypes();
                        for (int i = 0; i < MethodStatement.this.parameters.size(); ++i) {
                            VariableReference parameterVar = MethodStatement.this.parameters.get(i);
                            inputs[i] = parameterVar.getObject(scope);
                            if (inputs[i] == null && MethodStatement.this.method.getMethod().getParameterTypes()[i].isPrimitive()) {
                                throw new CodeUnderTestException(new NullPointerException());
                            }
                            if (inputs[i] == null || TypeUtils.isAssignable(inputs[i].getClass(), parameterTypes[i])) continue;
                            throw new CodeUnderTestException(new UncompilableCodeException("Cannot assign " + parameterVar.getVariableClass().getName() + " to " + parameterTypes[i]));
                        }
                        Object object = callee_object = MethodStatement.this.method.isStatic() ? null : MethodStatement.this.callee.getObject(scope);
                        if (!MethodStatement.this.method.isStatic() && callee_object == null) {
                            throw new CodeUnderTestException(new NullPointerException());
                        }
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new EvosuiteError(e);
                    }
                    Object ret = MethodStatement.this.method.getMethod().invoke(callee_object, inputs);
                    if (MethodStatement.this.method.getReturnType() instanceof Class && !(returnClass = (Class)MethodStatement.this.method.getReturnType()).isPrimitive() && ret != null && !returnClass.isAssignableFrom(ret.getClass())) {
                        throw new ClassCastException("Cannot assign " + MethodStatement.this.method.getReturnType() + " to variable of type " + MethodStatement.this.retval.getType());
                    }
                    try {
                        MethodStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    HashSet<Class<? extends Throwable>> t = new HashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            exceptionThrown = e.getCause();
            logger.debug("Exception thrown in method {}: {}", (Object)this.method.getName(), (Object)exceptionThrown);
            return exceptionThrown;
        }
    }

    @Override
    public boolean isDeclaredException(Throwable t) {
        for (Class<?> declaredException : this.method.getMethod().getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public StatementInterface copy(TestCase newTestCase, int offset) {
        MethodStatement m;
        ArrayList<VariableReference> new_params = new ArrayList<VariableReference>();
        for (VariableReference r : this.parameters) {
            new_params.add(r.copy(newTestCase, offset));
        }
        if (this.isStatic()) {
            m = new MethodStatement(newTestCase, this.method.copy(), null, new_params);
        } else {
            VariableReference newCallee = this.callee.copy(newTestCase, offset);
            m = new MethodStatement(newTestCase, this.method.copy(), newCallee, new_params);
        }
        if (this.retval instanceof ArrayReference && !(m.getReturnValue() instanceof ArrayReference)) {
            ArrayReference newRetVal = new ArrayReference(newTestCase, this.retval.getGenericClass(), ((ArrayReference)this.retval).getArrayLength());
            m.setRetval(newRetVal);
        }
        return m;
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        if (this.isInstanceMethod()) {
            references.add(this.callee);
            if (this.callee.getAdditionalVariableReference() != null) {
                references.add(this.callee.getAdditionalVariableReference());
            }
        }
        references.addAll(this.parameters);
        for (VariableReference param : this.parameters) {
            if (param.getAdditionalVariableReference() == null) continue;
            references.add(param.getAdditionalVariableReference());
        }
        references.addAll(this.getAssertionReferences());
        return references;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (this.retval.equals(var1)) {
            this.retval = var2;
        }
        if (this.isInstanceMethod()) {
            if (this.callee.equals(var1)) {
                this.callee = var2;
            } else {
                this.callee.replaceAdditionalVariableReference(var1, var2);
            }
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).equals(var1)) {
                this.parameters.set(i, var2);
                continue;
            }
            this.parameters.get(i).replaceAdditionalVariableReference(var1, var2);
        }
    }

    public List<VariableReference> getParameterReferences() {
        return this.parameters;
    }

    @Override
    public int getNumParameters() {
        return this.parameters.size() + (this.isStatic() ? 0 : 1);
    }

    public void replaceParameterReference(VariableReference var, int numParameter) {
        assert (numParameter >= 0);
        assert (numParameter < this.parameters.size());
        this.parameters.set(numParameter, var);
    }

    public String toString() {
        return this.method.getName() + org.objectweb.asm.Type.getMethodDescriptor(this.method.getMethod());
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        MethodStatement ms = (MethodStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.method.equals(ms.method)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).equals(ms.parameters.get(i))) continue;
            return false;
        }
        if (!this.retval.equals(ms.retval)) {
            return false;
        }
        if (this.callee == null && ms.callee != null || this.callee != null && ms.callee == null) {
            return false;
        }
        if (this.callee == null) {
            return true;
        }
        return this.callee.equals(ms.callee);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        Label start = mg.newLabel();
        Label end = mg.newLabel();
        mg.mark(start);
        if (!this.isStatic()) {
            this.callee.loadBytecode(mg, locals);
            if (!this.method.getMethod().getDeclaringClass().equals(this.callee.getVariableClass())) {
                logger.debug("Types don't match - casting!");
                mg.cast(org.objectweb.asm.Type.getType(this.callee.getVariableClass()), org.objectweb.asm.Type.getType(this.method.getMethod().getDeclaringClass()));
            }
        }
        int num = 0;
        for (VariableReference parameter : this.parameters) {
            parameter.loadBytecode(mg, locals);
            if (this.method.getMethod().getParameterTypes()[num].isPrimitive()) {
                if (parameter.getGenericClass().isWrapperType()) {
                    mg.unbox(org.objectweb.asm.Type.getType(parameter.getGenericClass().getUnboxedType()));
                } else if (!parameter.getGenericClass().isPrimitive()) {
                    Class<?> parameterClass = new GenericClass(this.method.getParameterTypes()[num]).getBoxedType();
                    org.objectweb.asm.Type parameterType = org.objectweb.asm.Type.getType(parameterClass);
                    mg.checkCast(parameterType);
                    mg.unbox(org.objectweb.asm.Type.getType(this.method.getMethod().getParameterTypes()[num]));
                }
                if (!this.method.getParameterTypes()[num].equals(parameter.getVariableClass())) {
                    logger.debug("Types don't match - casting!");
                    mg.cast(org.objectweb.asm.Type.getType(parameter.getVariableClass()), org.objectweb.asm.Type.getType(this.method.getMethod().getParameterTypes()[num]));
                }
            } else if (parameter.getVariableClass().isPrimitive()) {
                mg.box(org.objectweb.asm.Type.getType(parameter.getVariableClass()));
            }
            ++num;
        }
        logger.debug("Invoking method");
        if (this.isStatic()) {
            mg.invokeStatic(org.objectweb.asm.Type.getType(this.method.getMethod().getDeclaringClass()), Method.getMethod(this.method.getMethod()));
        } else if (!this.callee.getVariableClass().isInterface()) {
            mg.invokeVirtual(org.objectweb.asm.Type.getType(this.callee.getVariableClass()), Method.getMethod(this.method.getMethod()));
        } else {
            mg.invokeInterface(org.objectweb.asm.Type.getType(this.callee.getVariableClass()), Method.getMethod(this.method.getMethod()));
        }
        if (!this.retval.isVoid()) {
            if (!this.retval.getVariableClass().equals(this.method.getReturnType())) {
                if (!this.retval.getVariableClass().isPrimitive()) {
                    mg.checkCast(org.objectweb.asm.Type.getType(this.retval.getVariableClass()));
                } else {
                    mg.cast(org.objectweb.asm.Type.getType(this.method.getMethod().getReturnType()), org.objectweb.asm.Type.getType(this.retval.getVariableClass()));
                }
            }
            this.retval.storeBytecode(mg, locals);
        }
        mg.mark(end);
        Label l = mg.newLabel();
        mg.goTo(l);
        mg.catchException(start, end, org.objectweb.asm.Type.getType(Throwable.class));
        mg.pop();
        if (!this.retval.isVoid()) {
            Class<?> clazz = this.retval.getVariableClass();
            if (clazz.equals(Boolean.TYPE)) {
                mg.push(false);
            } else if (clazz.equals(Character.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Integer.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Short.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Long.TYPE)) {
                mg.push(0L);
            } else if (clazz.equals(Float.TYPE)) {
                mg.push(0.0f);
            } else if (clazz.equals(Double.TYPE)) {
                mg.push(0.0);
            } else if (clazz.equals(Byte.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(String.class)) {
                mg.push("");
            } else {
                mg.visitInsn(1);
            }
            this.retval.storeBytecode(mg, locals);
        }
        mg.mark(l);
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        Set<Class<?>> ex = super.getDeclaredExceptions();
        for (Class<?> t : this.method.getMethod().getExceptionTypes()) {
            ex.add(t);
        }
        return ex;
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        references.add(this.retval);
        if (this.isInstanceMethod()) {
            references.add(this.callee);
            if (this.callee instanceof ArrayIndex) {
                references.add(((ArrayIndex)this.callee).getArray());
            }
        }
        references.addAll(this.parameters);
        for (VariableReference param : this.parameters) {
            if (!(param instanceof ArrayIndex)) continue;
            references.add(((ArrayIndex)param).getArray());
        }
        return references;
    }

    @Override
    public boolean isAccessible() {
        if (!this.method.isAccessible()) {
            return false;
        }
        return super.isAccessible();
    }

    @Override
    public boolean isValid() {
        assert (super.isValid());
        for (VariableReference v : this.parameters) {
            v.getStPosition();
        }
        if (!this.isStatic()) {
            this.callee.getStPosition();
        }
        return true;
    }

    @Override
    public boolean same(StatementInterface s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        MethodStatement ms = (MethodStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).same(ms.parameters.get(i))) continue;
            return false;
        }
        if (!this.method.equals(ms.method)) {
            return false;
        }
        if (!this.retval.same(ms.retval)) {
            return false;
        }
        if (this.callee == null && ms.callee != null || this.callee != null && ms.callee == null) {
            return false;
        }
        if (this.callee == null) {
            return true;
        }
        return this.callee.same(ms.callee);
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        int numParameter;
        if (Randomness.nextDouble() >= Properties.P_CHANGE_PARAMETER) {
            return false;
        }
        List<VariableReference> parameters = this.getParameterReferences();
        if (parameters.isEmpty()) {
            return false;
        }
        int max = parameters.size();
        if (!this.isStatic()) {
            ++max;
        }
        if ((numParameter = Randomness.nextInt(max)) == parameters.size()) {
            VariableReference callee = this.getCallee();
            List<VariableReference> objects = test.getObjects(callee.getType(), this.getPosition());
            objects.remove(callee);
            if (objects.isEmpty()) {
                return false;
            }
            VariableReference replacement = Randomness.choice(objects);
            this.setCallee(replacement);
            return true;
        }
        VariableReference parameter = parameters.get(numParameter);
        List<VariableReference> objects = test.getObjects(parameter.getType(), this.getPosition());
        objects.remove(parameter);
        objects.remove(this.getReturnValue());
        NullStatement nullStatement = new NullStatement(test, parameter.getType());
        StatementInterface primitiveCopy = null;
        if (!parameter.isPrimitive()) {
            objects.add(nullStatement.getReturnValue());
        } else {
            StatementInterface originalStatement = test.getStatement(parameter.getStPosition());
            if (originalStatement instanceof PrimitiveStatement) {
                PrimitiveStatement copy = (PrimitiveStatement)originalStatement.clone(test);
                copy.delta();
                objects.add(copy.getReturnValue());
                primitiveCopy = copy;
            }
        }
        if (objects.isEmpty()) {
            return false;
        }
        VariableReference replacement = Randomness.choice(objects);
        if (replacement == nullStatement.getReturnValue()) {
            test.addStatement(nullStatement, this.getPosition());
        } else if (primitiveCopy != null && replacement == primitiveCopy.getReturnValue()) {
            test.addStatement(primitiveCopy, this.getPosition());
        }
        this.replaceParameterReference(replacement, numParameter);
        return true;
    }

    public GenericMethod getAccessibleObject() {
        return this.method;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.method.changeClassLoader(loader);
        super.changeClassLoader(loader);
    }
}

