/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.testcase.AbstractStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.VariableReference;
import org.evosuite.testcase.VariableReferenceImpl;
import org.evosuite.utils.GenericAccessibleObject;
import org.objectweb.asm.commons.GeneratorAdapter;

public class PrimitiveExpression
extends AbstractStatement {
    private static final long serialVersionUID = 1L;
    private VariableReference leftOperand;
    private final Operator operator;
    private VariableReference rightOperand;

    public PrimitiveExpression(TestCase testCase, VariableReference reference, VariableReference leftOperand, Operator operator, VariableReference rightOperand) {
        super(testCase, reference);
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
    }

    @Override
    public StatementInterface copy(TestCase newTestCase, int offset) {
        VariableReferenceImpl newRetVal = new VariableReferenceImpl(newTestCase, this.retval.getType());
        VariableReference newLeftOperand = newTestCase.getStatement(this.leftOperand.getStPosition()).getReturnValue();
        VariableReference newRightOperand = newTestCase.getStatement(this.rightOperand.getStPosition()).getReturnValue();
        return new PrimitiveExpression(newTestCase, newRetVal, newLeftOperand, this.operator, newRightOperand);
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Object o1 = scope.getObject(this.leftOperand);
        Object o2 = scope.getObject(this.rightOperand);
        switch (this.operator) {
            case EQUALS: {
                if (o1 == o2) {
                    scope.setObject(this.retval, true);
                    break;
                }
                scope.setObject(this.retval, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Method execute not implemented!");
            }
        }
        return null;
    }

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        throw new UnsupportedOperationException("Method getAccessibleObject not implemented!");
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        throw new UnsupportedOperationException("Method getBytecode not implemented!");
    }

    @Override
    public String getCode() {
        String code = ((Class)this.retval.getType()).getSimpleName() + " " + this.retval.getName() + " = " + this.leftOperand.getName() + " " + this.operator.toCode() + " " + this.rightOperand.getName() + ";";
        return code;
    }

    public VariableReference getLeftOperand() {
        return this.leftOperand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public VariableReference getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        throw new UnsupportedOperationException("Method getUniqueVariableReferences not implemented!");
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        HashSet<VariableReference> result = new HashSet<VariableReference>();
        result.add(this.retval);
        result.add(this.leftOperand);
        result.add(this.rightOperand);
        return result;
    }

    @Override
    public boolean isAssignmentStatement() {
        throw new UnsupportedOperationException("Method isAssignmentStatement not implemented!");
    }

    @Override
    public void replace(VariableReference oldVar, VariableReference newVar) {
        if (this.leftOperand.equals(oldVar)) {
            this.leftOperand = newVar;
        }
        if (this.rightOperand.equals(oldVar)) {
            this.rightOperand = newVar;
        }
    }

    @Override
    public boolean same(StatementInterface s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        PrimitiveExpression ps = (PrimitiveExpression)s;
        return this.operator.equals((Object)ps.operator) && this.leftOperand.same(ps.leftOperand) && this.rightOperand.same(ps.rightOperand);
    }

    public String toString() {
        return this.getCode();
    }

    public static enum Operator {
        TIMES("*"),
        DIVIDE("/"),
        REMAINDER("%"),
        PLUS("+"),
        MINUS("-"),
        LEFT_SHIFT("<<"),
        RIGHT_SHIFT_SIGNED(">>"),
        RIGHT_SHIFT_UNSIGNED(">>>"),
        LESS("<"),
        GREATER(">"),
        LESS_EQUALS("<="),
        GREATER_EQUALS(">="),
        EQUALS("=="),
        NOT_EQUALS("!="),
        XOR("^"),
        AND("&"),
        OR("|"),
        CONDITIONAL_AND("&&"),
        CONDITIONAL_OR("||");

        private final String code;

        public static Operator toOperator(String code) {
            for (Operator operator : Operator.values()) {
                if (!operator.code.equals(code)) continue;
                return operator;
            }
            throw new RuntimeException("No operator for " + code);
        }

        private Operator(String code) {
            this.code = code;
        }

        public String toCode() {
            return this.code;
        }
    }
}

