/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseMinimizer {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseMinimizer.class);
    private final Set<TestFitnessFunction> fitnessFunctions = new HashSet<TestFitnessFunction>();

    public TestCaseMinimizer(Collection<TestFitnessFunction> fitnessFunctions) {
        this.fitnessFunctions.addAll(fitnessFunctions);
    }

    public TestCaseMinimizer(TestFitnessFunction fitnessFunction) {
        this.fitnessFunctions.add(fitnessFunction);
    }

    public boolean removeUnusedVariables(TestCase t) {
        ArrayList<Integer> to_delete = new ArrayList<Integer>();
        boolean has_deleted = false;
        int num = 0;
        for (StatementInterface s : t) {
            VariableReference var = s.getReturnValue();
            if (!t.hasReferences(var)) {
                to_delete.add(num);
                has_deleted = true;
            }
            ++num;
        }
        Collections.sort(to_delete, Collections.reverseOrder());
        for (Integer position : to_delete) {
            t.remove(position);
        }
        return has_deleted;
    }

    private static boolean isWorse(FitnessFunction<TestChromosome> fitness, TestChromosome oldChromosome, TestChromosome newChromosome) {
        if (fitness.isMaximizationFunction() ? oldChromosome.getFitness(fitness) > newChromosome.getFitness(fitness) : newChromosome.getFitness(fitness) > oldChromosome.getFitness(fitness)) {
            return true;
        }
        for (SecondaryObjective objective : TestChromosome.getSecondaryObjectives()) {
            if (objective.compareChromosomes(oldChromosome, newChromosome) >= 0) continue;
            return true;
        }
        return false;
    }

    public Map<TestFitnessFunction, Double> getFitnessValues(TestChromosome test) {
        HashMap<TestFitnessFunction, Double> fitnessMap = new HashMap<TestFitnessFunction, Double>();
        for (TestFitnessFunction fitness : this.fitnessFunctions) {
            fitnessMap.put(fitness, fitness.getFitness(test));
        }
        return fitnessMap;
    }

    public void minimize(TestChromosome c) {
        if (!Properties.MINIMIZE) {
            return;
        }
        logger.info("Minimizing test case");
        TestFactory testFactory = TestFactory.getInstance();
        Map<TestFitnessFunction, Double> fitness = this.getFitnessValues(c);
        logger.debug("Start fitness values: " + fitness);
        boolean changed = true;
        block2: while (changed) {
            changed = false;
            for (int i = c.test.size() - 1; i >= 0; --i) {
                logger.debug("Deleting statement {}", (Object)c.test.getStatement(i).getCode());
                TestChromosome copy = (TestChromosome)c.clone();
                try {
                    c.setChanged(true);
                    testFactory.deleteStatementGracefully(c.test, i);
                }
                catch (ConstructionFailedException e) {
                    c.setChanged(false);
                    c.test = copy.test;
                    logger.debug("Deleting failed");
                    continue;
                }
                Map<TestFitnessFunction, Double> newFitness = this.getFitnessValues(c);
                boolean isWorse = false;
                for (TestFitnessFunction fitnessFunction : this.fitnessFunctions) {
                    if (!TestCaseMinimizer.isWorse(fitnessFunction, copy, c)) continue;
                    isWorse = true;
                    break;
                }
                if (!isWorse) {
                    logger.debug("Keeping shorter version");
                    fitness = newFitness;
                    changed = true;
                    continue block2;
                }
                logger.debug("Keeping original version");
                c.test = copy.test;
                c.copyCachedResults(copy);
                c.setFitnesses(copy.getFitnesses());
                c.setLastFitnesses(copy.getLastFitnesses());
                c.setChanged(false);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Minimized test case: ");
            logger.debug(c.test.toCode());
        }
    }
}

