/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationExecutionResult;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.localsearch.TestCaseLocalSearch;
import org.evosuite.ga.operators.mutation.MutationHistory;
import org.evosuite.setup.TestCluster;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.ConcolicMutation;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.StringPrimitiveStatement;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestMutationHistoryEntry;
import org.evosuite.testsuite.CurrentChromosomeTracker;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.Randomness;

public class TestChromosome
extends ExecutableChromosome {
    private static final long serialVersionUID = 7532366007973252782L;
    protected TestCase test = new DefaultTestCase();
    protected MutationHistory<TestMutationHistoryEntry> mutationHistory = new MutationHistory();
    private static final List<SecondaryObjective> secondaryObjectives = new ArrayList<SecondaryObjective>();

    public void setTestCase(TestCase testCase) {
        this.test = testCase;
    }

    public TestCase getTestCase() {
        return this.test;
    }

    @Override
    public void setLastExecutionResult(ExecutionResult lastExecutionResult) {
        if (lastExecutionResult == null) {
            return;
        }
        assert (lastExecutionResult.test.equals(this.test));
        this.lastExecutionResult = lastExecutionResult;
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        if (changed) {
            this.clearCachedResults();
        }
        CurrentChromosomeTracker.getInstance().changed(this);
    }

    @Override
    public Chromosome clone() {
        TestChromosome c = new TestChromosome();
        c.test = this.test.clone();
        c.setFitnesses(this.getFitnesses());
        c.setLastFitnesses(this.getLastFitnesses());
        c.solution = this.solution;
        c.copyCachedResults(this);
        c.setChanged(this.isChanged());
        if (Properties.LOCAL_SEARCH_SELECTIVE) {
            for (TestMutationHistoryEntry mutation : this.mutationHistory) {
                c.mutationHistory.addMutationEntry(mutation.clone(c.getTestCase()));
            }
        }
        return c;
    }

    @Override
    public void copyCachedResults(ExecutableChromosome other) {
        if (this.test == null) {
            throw new RuntimeException("Test is null!");
        }
        if (other.lastExecutionResult != null) {
            this.lastExecutionResult = other.lastExecutionResult.clone();
            this.lastExecutionResult.test = this.test;
        }
        if (other.lastMutationResult != null) {
            for (Mutation mutation : other.lastMutationResult.keySet()) {
                MutationExecutionResult copy = other.lastMutationResult.get(mutation);
                this.lastMutationResult.put(mutation, copy);
            }
        }
    }

    @Override
    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
        int i;
        logger.debug("Crossover starting");
        TestChromosome offspring = new TestChromosome();
        TestFactory testFactory = TestFactory.getInstance();
        for (i = 0; i < position1; ++i) {
            offspring.test.addStatement(this.test.getStatement(i).clone(offspring.test));
        }
        for (i = position2; i < other.size(); ++i) {
            testFactory.appendStatement(offspring.test, ((TestChromosome)other).test.getStatement(i));
        }
        if (!Properties.CHECK_MAX_LENGTH || offspring.test.size() <= Properties.CHROMOSOME_LENGTH) {
            this.test = offspring.test;
        }
        this.setChanged(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestChromosome other = (TestChromosome)obj;
        return !(this.test == null ? other.test != null : !this.test.equals(other.test));
    }

    @Override
    public int hashCode() {
        return this.test.hashCode();
    }

    public MutationHistory<TestMutationHistoryEntry> getMutationHistory() {
        return this.mutationHistory;
    }

    public boolean hasRelevantMutations() {
        Integer lastPos;
        if (this.mutationHistory.isEmpty()) {
            logger.info("Mutation history is empty");
            return false;
        }
        int lastPosition = this.test.size() - 1;
        if (this.lastExecutionResult != null && !this.isChanged() && (lastPos = this.lastExecutionResult.getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        for (TestMutationHistoryEntry mutation : this.mutationHistory) {
            logger.info("Considering: " + (Object)((Object)mutation.getMutationType()));
            if (mutation.getMutationType() == TestMutationHistoryEntry.TestMutation.DELETION || mutation.getStatement().getPosition() > lastPosition || Properties.LOCAL_SEARCH_SELECTIVE_PRIMITIVES && !(mutation.getStatement() instanceof PrimitiveStatement) || !this.test.hasReferences(mutation.getStatement().getReturnValue()) && !mutation.getStatement().getReturnClass().equals(Properties.getTargetClass())) continue;
            int newPosition = -1;
            for (int i = 0; i <= lastPosition; ++i) {
                if (this.test.getStatement(i) != mutation.getStatement()) continue;
                newPosition = i;
                break;
            }
            assert (newPosition >= 0);
            if (newPosition < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean localSearch(LocalSearchObjective<? extends Chromosome> objective) {
        TestCaseLocalSearch localSearch = TestCaseLocalSearch.getLocalSearch();
        return localSearch.doSearch(this, objective);
    }

    @Override
    public void mutate() {
        boolean changed = false;
        this.mutationHistory.clear();
        if (Randomness.nextDouble() <= Properties.P_TEST_DELETE) {
            logger.debug("Mutation: delete");
            changed = this.mutationDelete();
        }
        if (Randomness.nextDouble() <= Properties.P_TEST_CHANGE) {
            logger.debug("Mutation: change");
            if (this.mutationChange()) {
                changed = true;
            }
        }
        if (Randomness.nextDouble() <= Properties.P_TEST_INSERT) {
            logger.debug("Mutation: insert");
            if (this.mutationInsert()) {
                changed = true;
            }
        }
        if (changed) {
            this.setChanged(true);
        }
        for (StatementInterface s : this.test) {
            s.isValid();
        }
    }

    private int getLastMutatableStatement() {
        ExecutionResult result = this.getLastExecutionResult();
        if (result != null && !result.noThrownExceptions()) {
            int pos = result.getFirstPositionOfThrownException();
            if (pos >= this.test.size()) {
                return this.test.size() - 1;
            }
            return pos;
        }
        return this.test.size() - 1;
    }

    private boolean mutationDelete() {
        boolean changed = false;
        int lastMutatableStatement = this.getLastMutatableStatement();
        double pl = 1.0 / (double)(lastMutatableStatement + 1);
        TestFactory testFactory = TestFactory.getInstance();
        for (int num = lastMutatableStatement; num >= 0; --num) {
            if (!(Randomness.nextDouble() <= pl)) continue;
            try {
                TestCase copy = this.test.clone();
                changed = true;
                this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.DELETION));
                testFactory.deleteStatementGracefully(copy, num);
                this.test = copy;
                continue;
            }
            catch (ConstructionFailedException e) {
                logger.warn("Deletion of statement failed: " + this.test.getStatement(num).getCode());
                logger.warn(this.test.toCode());
            }
        }
        return changed;
    }

    private boolean mutationChange() {
        boolean changed = false;
        int lastMutatableStatement = this.getLastMutatableStatement();
        double pl = 1.0 / (double)(lastMutatableStatement + 1);
        TestFactory testFactory = TestFactory.getInstance();
        if (Randomness.nextDouble() < Properties.CONCOLIC_MUTATION) {
            try {
                changed = this.mutationConcolic();
            }
            catch (Exception exc) {
                logger.info("Encountered exception when trying to use concolic mutation.", (Object)exc.getMessage());
                logger.debug("Detailed exception trace: ", exc);
            }
        }
        if (!changed) {
            for (int position = 0; position <= lastMutatableStatement; ++position) {
                StatementInterface statement = this.test.getStatement(position);
                if (!(Randomness.nextDouble() <= pl)) continue;
                assert (this.test.isValid());
                int oldDistance = statement.getReturnValue().getDistance();
                if (statement instanceof StringPrimitiveStatement) {
                    // empty if block
                }
                if (statement.mutate(this.test, testFactory)) {
                    changed = true;
                    this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.CHANGE, statement));
                    assert (this.test.isValid());
                } else if (!statement.isAssignmentStatement()) {
                    int pos = statement.getPosition();
                    if (testFactory.changeRandomCall(this.test, statement)) {
                        changed = true;
                        this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.CHANGE, this.test.getStatement(pos)));
                    }
                    assert (this.test.isValid());
                }
                statement.getReturnValue().setDistance(oldDistance);
                position = statement.getPosition();
            }
        }
        return changed;
    }

    private boolean mutationInsert() {
        boolean changed = false;
        double ALPHA = Properties.P_STATEMENT_INSERTION;
        int count = 0;
        TestFactory testFactory = TestFactory.getInstance();
        while (Randomness.nextDouble() <= Math.pow(ALPHA, count) && (!Properties.CHECK_MAX_LENGTH || this.size() < Properties.CHROMOSOME_LENGTH)) {
            ++count;
            int position = testFactory.insertRandomStatement(this.test, this.getLastMutatableStatement());
            if (position < 0 || position >= this.test.size()) continue;
            changed = true;
            this.mutationHistory.addMutationEntry(new TestMutationHistoryEntry(TestMutationHistoryEntry.TestMutation.INSERTION, this.test.getStatement(position)));
        }
        return changed;
    }

    private boolean mutationConcolic() {
        logger.info("Applying DSE mutation");
        List<BranchCondition> branches = ConcolicExecution.getSymbolicPath(this);
        logger.debug("Conditions: " + branches);
        if (branches.isEmpty()) {
            return false;
        }
        boolean mutated = false;
        ArrayList<BranchCondition> targetBranches = new ArrayList<BranchCondition>();
        for (BranchCondition branch : branches) {
            if (!TestCluster.isTargetClassName(branch.getClassName())) continue;
            targetBranches.add(branch);
        }
        BranchCondition branch = null;
        branch = targetBranches.isEmpty() ? Randomness.choice(branches) : (BranchCondition)Randomness.choice(targetBranches);
        logger.debug("Trying to negate branch " + branch.getInstructionIndex() + " - have " + targetBranches.size() + "/" + branches.size() + " target branches");
        TestCase newTest = ConcolicMutation.negateCondition(branch, this.test);
        if (newTest != null) {
            logger.debug("CONCOLIC: Created new test");
            this.test = newTest;
            this.setChanged(true);
            this.lastExecutionResult = null;
        } else {
            logger.debug("CONCOLIC: Did not create new test");
        }
        return mutated;
    }

    @Override
    public int size() {
        return this.test.size();
    }

    @Override
    public int compareTo(Chromosome o) {
        int result = super.compareTo(o);
        if (result != 0) {
            return result;
        }
        if (o instanceof TestChromosome) {
            return this.test.toCode().compareTo(((TestChromosome)o).test.toCode());
        }
        return result;
    }

    public String toString() {
        return this.test.toCode();
    }

    public boolean hasException() {
        return this.lastExecutionResult == null ? false : !this.lastExecutionResult.noThrownExceptions();
    }

    @Override
    public ExecutionResult executeForFitnessFunction(TestSuiteFitnessFunction testSuiteFitnessFunction) {
        return testSuiteFitnessFunction.runTest(this.test);
    }

    @Override
    public int compareSecondaryObjective(Chromosome o) {
        SecondaryObjective so;
        int objective = 0;
        int c = 0;
        while (c == 0 && objective < secondaryObjectives.size() && (so = secondaryObjectives.get(objective++)) != null) {
            c = so.compareChromosomes(this, o);
        }
        return c;
    }

    public static void addSecondaryObjective(SecondaryObjective objective) {
        secondaryObjectives.add(objective);
    }

    public static void removeSecondaryObjective(SecondaryObjective objective) {
        secondaryObjectives.remove(objective);
    }

    public static List<SecondaryObjective> getSecondaryObjectives() {
        return secondaryObjectives;
    }
}

