/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.List;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public abstract class TestFitnessFunction
extends FitnessFunction<TestChromosome>
implements Comparable<TestFitnessFunction> {
    private static final long serialVersionUID = 5602125855207061901L;
    static boolean warnedAboutIsSimilarTo = false;

    public abstract double getFitness(TestChromosome var1, ExecutionResult var2);

    @Override
    public double getFitness(TestChromosome individual) {
        logger.trace("Executing test case on original");
        ExecutionResult origResult = individual.getLastExecutionResult();
        if (origResult == null || individual.isChanged()) {
            origResult = this.runTest(individual.test);
            individual.setLastExecutionResult(origResult);
            individual.setChanged(false);
        }
        double fitness = this.getFitness(individual, origResult);
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    @Override
    public abstract int compareTo(TestFitnessFunction var1);

    public ExecutionResult runTest(TestCase test) {
        return TestCaseExecutor.runTest(test);
    }

    public boolean isCovered(List<TestCase> tests) {
        for (TestCase test : tests) {
            if (!this.isCovered(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isCoveredByResults(List<ExecutionResult> tests) {
        for (ExecutionResult result : tests) {
            if (!this.isCovered(result)) continue;
            return true;
        }
        return false;
    }

    public boolean isCoveredBy(TestSuiteChromosome testSuite) {
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            if (!this.isCovered(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isCovered(TestCase test) {
        TestChromosome c = new TestChromosome();
        c.test = test;
        return this.isCovered(c);
    }

    public boolean isCovered(TestChromosome tc) {
        ExecutionResult result = tc.getLastExecutionResult();
        if (result == null || tc.isChanged()) {
            result = this.runTest(tc.test);
            tc.setLastExecutionResult(result);
            tc.setChanged(false);
        }
        return this.isCovered(tc, result);
    }

    public boolean isCovered(TestChromosome individual, ExecutionResult result) {
        boolean covered;
        boolean bl = covered = this.getFitness(individual, result) == 0.0;
        if (covered) {
            individual.test.addCoveredGoal(this);
        }
        return covered;
    }

    public boolean isCovered(ExecutionResult result) {
        TestChromosome chromosome = new TestChromosome();
        chromosome.setTestCase(result.test);
        chromosome.setLastExecutionResult(result);
        chromosome.setChanged(false);
        return this.isCovered(chromosome, result);
    }

    @Override
    public boolean isMaximizationFunction() {
        return false;
    }

    public abstract String getTargetClass();

    public abstract String getTargetMethod();
}

