/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.Serializable;
import org.evosuite.ga.operators.mutation.MutationHistoryEntry;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;

public class TestMutationHistoryEntry
implements MutationHistoryEntry,
Serializable {
    private static final long serialVersionUID = -4278409687247714553L;
    protected TestMutation mutationType;
    protected StatementInterface statement;
    public String whatwasit;

    public TestMutationHistoryEntry(TestMutation type, StatementInterface statement) {
        this.mutationType = type;
        this.statement = statement;
        this.whatwasit = statement.getCode() + " at position " + statement.getPosition();
    }

    public TestMutationHistoryEntry(TestMutation type) {
        this.mutationType = type;
        this.statement = null;
        this.whatwasit = "Deleted some statement";
    }

    public StatementInterface getStatement() {
        return this.statement;
    }

    public TestMutation getMutationType() {
        return this.mutationType;
    }

    public TestMutationHistoryEntry clone(TestCase newTest) {
        if (this.statement == null) {
            return new TestMutationHistoryEntry(this.mutationType);
        }
        return new TestMutationHistoryEntry(this.mutationType, newTest.getStatement(this.statement.getPosition()));
    }

    public String toString() {
        return (Object)((Object)this.mutationType) + " at " + this.statement;
    }

    public static enum TestMutation {
        CHANGE,
        INSERTION,
        DELETION;

    }
}

