/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public abstract class AbstractTestSuiteChromosome<T extends ExecutableChromosome>
extends Chromosome {
    private static final long serialVersionUID = 1L;
    protected List<T> tests = new ArrayList<T>();
    protected Set<T> unmodifiableTests = new HashSet<T>();
    protected ChromosomeFactory<T> testChromosomeFactory;

    protected AbstractTestSuiteChromosome() {
    }

    protected AbstractTestSuiteChromosome(ChromosomeFactory<T> testChromosomeFactory) {
        this.testChromosomeFactory = testChromosomeFactory;
    }

    public ChromosomeFactory<T> getTestChromosomeFactory() {
        return this.testChromosomeFactory;
    }

    protected AbstractTestSuiteChromosome(AbstractTestSuiteChromosome<T> source) {
        this(source.testChromosomeFactory);
        for (ExecutableChromosome test : source.tests) {
            this.addTest((ExecutableChromosome)test.clone());
        }
        this.setFitnesses(source.getFitnesses());
        this.setLastFitnesses(source.getLastFitnesses());
        this.setChanged(source.isChanged());
        this.setCoverages(source.getCoverages());
        this.setNumsOfCoveredGoals(source.getNumsOfCoveredGoals());
    }

    public void addTest(T test) {
        this.tests.add(test);
        this.unmodifiableTests.remove(test);
        this.setChanged(true);
    }

    public void deleteTest(T test) {
        boolean changed = this.tests.remove(test);
        if (!changed) {
            changed = this.unmodifiableTests.remove(test);
        }
        if (changed) {
            this.setChanged(true);
        }
    }

    public void addTests(Collection<T> tests) {
        for (ExecutableChromosome test : tests) {
            tests.add(test);
            this.unmodifiableTests.remove(test);
        }
        if (!tests.isEmpty()) {
            this.setChanged(true);
        }
    }

    public void addUnmodifiableTest(T test) {
        this.tests.add(test);
        this.unmodifiableTests.add(test);
        this.setChanged(true);
    }

    @Override
    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
        if (!(other instanceof AbstractTestSuiteChromosome)) {
            throw new IllegalArgumentException("AbstractTestSuiteChromosome.crossOver() called with parameter of unsupported type " + other.getClass());
        }
        AbstractTestSuiteChromosome chromosome = (AbstractTestSuiteChromosome)other;
        while (this.tests.size() > position1) {
            this.tests.remove(position1);
            this.unmodifiableTests.remove(position1);
        }
        for (int num = position2; num < other.size(); ++num) {
            ExecutableChromosome otherTest = (ExecutableChromosome)chromosome.tests.get(num);
            ExecutableChromosome clonedTest = (ExecutableChromosome)otherTest.clone();
            this.tests.add(clonedTest);
            if (!chromosome.unmodifiableTests.contains(otherTest)) continue;
            this.unmodifiableTests.add(clonedTest);
        }
        this.setChanged(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestSuiteChromosome)) {
            return false;
        }
        TestSuiteChromosome other = (TestSuiteChromosome)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((ExecutableChromosome)this.tests.get(i)).equals(other.tests.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.tests.hashCode();
    }

    @Override
    public void mutate() {
        boolean changed = false;
        for (int i = 0; i < this.tests.size(); ++i) {
            ExecutableChromosome test = (ExecutableChromosome)this.tests.get(i);
            if (this.unmodifiableTests.contains(test) || !(Randomness.nextDouble() < 1.0 / (double)this.tests.size())) continue;
            test.mutate();
            changed = true;
        }
        double ALPHA = Properties.P_TEST_INSERTION;
        int count = 1;
        while (Randomness.nextDouble() <= Math.pow(ALPHA, count) && this.size() < Properties.MAX_SIZE) {
            ExecutableChromosome test = (ExecutableChromosome)this.testChromosomeFactory.getChromosome();
            this.tests.add(test);
            this.unmodifiableTests.remove(test);
            logger.debug("Adding new test case");
            changed = true;
            ++count;
        }
        if (changed) {
            this.setChanged(true);
        }
    }

    public int totalLengthOfTestCases() {
        int length = 0;
        for (ExecutableChromosome test : this.tests) {
            length += test.size();
        }
        return length;
    }

    @Override
    public int size() {
        return this.tests.size();
    }

    @Override
    public abstract boolean localSearch(LocalSearchObjective<? extends Chromosome> var1);

    @Override
    public abstract Chromosome clone();

    public T getTestChromosome(int index) {
        return (T)((ExecutableChromosome)this.tests.get(index));
    }

    public List<T> getTestChromosomes() {
        return this.tests;
    }

    public void setTestChromosome(int index, T test) {
        this.tests.set(index, test);
        this.setChanged(true);
    }
}

