/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class MinimizeExceptionsSecondaryObjective
extends SecondaryObjective {
    private static final long serialVersionUID = -4405276303273532040L;

    private int getNumExceptions(Chromosome chromosome) {
        int sum = 0;
        for (ExecutableChromosome test : ((TestSuiteChromosome)chromosome).tests) {
            if (test.getLastExecutionResult() == null) continue;
            sum += test.getLastExecutionResult().getNumberOfThrownExceptions();
        }
        return sum;
    }

    @Override
    public int compareChromosomes(Chromosome chromosome1, Chromosome chromosome2) {
        return this.getNumExceptions(chromosome1) - this.getNumExceptions(chromosome2);
    }

    @Override
    public int compareGenerations(Chromosome parent1, Chromosome parent2, Chromosome child1, Chromosome child2) {
        return Math.min(this.getNumExceptions(parent1), this.getNumExceptions(parent2)) - Math.min(this.getNumExceptions(child1), this.getNumExceptions(child2));
    }
}

