/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;

public class TestSuiteReplacementFunction
extends ReplacementFunction {
    private static final long serialVersionUID = -8472469271120247395L;

    public TestSuiteReplacementFunction(boolean maximize) {
        super(maximize);
    }

    public TestSuiteReplacementFunction() {
        super(false);
    }

    public int getLengthSum(AbstractTestSuiteChromosome<?> chromosome1, AbstractTestSuiteChromosome<?> chromosome2) {
        return chromosome1.totalLengthOfTestCases() + chromosome2.totalLengthOfTestCases();
    }

    @Override
    public boolean keepOffspring(Chromosome parent1, Chromosome parent2, Chromosome offspring1, Chromosome offspring2) {
        int cmp = this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2);
        if (Properties.CHECK_PARENTS_LENGTH) {
            int offspringLength = this.getLengthSum((AbstractTestSuiteChromosome)offspring1, (AbstractTestSuiteChromosome)offspring2);
            int parentLength = this.getLengthSum((AbstractTestSuiteChromosome)parent1, (AbstractTestSuiteChromosome)parent2);
            if (cmp == 0 && offspringLength <= parentLength) {
                return true;
            }
            if (this.maximize) {
                return cmp > 0;
            }
            return cmp < 0;
        }
        if (this.maximize) {
            return cmp >= 0;
        }
        return cmp <= 0;
    }
}

