/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.utils.GenericArrayTypeImpl;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericUtils;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.VarMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericAccessibleObject<T extends GenericAccessibleObject<?>>
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(GenericAccessibleObject.class);
    private static final long serialVersionUID = 7069749492563662621L;
    protected GenericClass owner;
    protected List<GenericClass> typeVariables = new ArrayList<GenericClass>();

    protected static Type getTypeFromExactReturnType(GenericArrayType returnType, GenericArrayType type) {
        return GenericArrayTypeImpl.createArrayType(GenericAccessibleObject.getTypeFromExactReturnType(returnType.getGenericComponentType(), type.getGenericComponentType()));
    }

    protected static Type getTypeFromExactReturnType(GenericArrayType returnType, ParameterizedType type) {
        return GenericArrayTypeImpl.createArrayType(GenericAccessibleObject.getTypeFromExactReturnType(returnType.getGenericComponentType(), (Type)type));
    }

    protected static Type getTypeFromExactReturnType(ParameterizedType returnType, GenericArrayType type) {
        return GenericArrayTypeImpl.createArrayType(GenericAccessibleObject.getTypeFromExactReturnType((Type)returnType, type.getGenericComponentType()));
    }

    protected static Type getTypeFromExactReturnType(ParameterizedType returnType, ParameterizedType type) {
        Map<TypeVariable<?>, Type> typeMap = TypeUtils.getTypeArguments(returnType);
        Type[] actualParameters = new Type[type.getActualTypeArguments().length];
        int num = 0;
        for (TypeVariable parameterType : ((Class)type.getRawType()).getTypeParameters()) {
            boolean replaced = false;
            for (TypeVariable<?> var : typeMap.keySet()) {
                if (!var.getName().equals(parameterType.getName())) continue;
                actualParameters[num] = typeMap.get(var);
                replaced = true;
                break;
            }
            if (!replaced) {
                actualParameters[num] = parameterType;
            }
            ++num;
        }
        return new ParameterizedTypeImpl((Class)type.getRawType(), actualParameters, null);
    }

    protected static Type getTypeFromExactReturnType(Type returnType, Type type) {
        if (returnType instanceof ParameterizedType && type instanceof ParameterizedType) {
            return GenericAccessibleObject.getTypeFromExactReturnType((ParameterizedType)returnType, (ParameterizedType)type);
        }
        if (returnType instanceof GenericArrayType && type instanceof GenericArrayType) {
            return GenericAccessibleObject.getTypeFromExactReturnType((GenericArrayType)returnType, (GenericArrayType)type);
        }
        if (returnType instanceof ParameterizedType && type instanceof GenericArrayType) {
            return GenericAccessibleObject.getTypeFromExactReturnType((ParameterizedType)returnType, (GenericArrayType)type);
        }
        if (returnType instanceof GenericArrayType && type instanceof ParameterizedType) {
            return GenericAccessibleObject.getTypeFromExactReturnType((GenericArrayType)returnType, (ParameterizedType)type);
        }
        if (returnType instanceof Class) {
            return returnType;
        }
        if (type instanceof Class) {
            return type;
        }
        throw new RuntimeException("Incompatible types: " + returnType.getClass() + " and " + type.getClass() + ": " + returnType + " and " + type);
    }

    protected static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public GenericAccessibleObject(GenericClass owner) {
        this.owner = owner;
    }

    public void changeClassLoader(ClassLoader loader) {
        this.owner.changeClassLoader(loader);
        for (GenericClass typeVariable : this.typeVariables) {
            typeVariable.changeClassLoader(loader);
        }
    }

    protected void copyTypeVariables(GenericAccessibleObject<?> copy) {
        for (GenericClass variable : this.typeVariables) {
            copy.typeVariables.add(new GenericClass(variable));
        }
    }

    public abstract T copy();

    public abstract T copyWithNewOwner(GenericClass var1);

    public abstract T copyWithOwnerFromReturnType(GenericClass var1) throws ConstructionFailedException;

    public abstract AccessibleObject getAccessibleObject();

    public abstract Class<?> getDeclaringClass();

    public abstract Type getGeneratedType();

    public GenericClass getGeneratedClass() {
        return new GenericClass(this.getGeneratedType());
    }

    public Type[] getGenericParameterTypes() {
        return new Type[0];
    }

    public abstract Type getGenericGeneratedType();

    public T getGenericInstantiation() throws ConstructionFailedException {
        T copy = this.copy();
        if (!this.hasTypeParameters()) {
            ((GenericAccessibleObject)copy).owner = ((GenericAccessibleObject)copy).getOwnerClass().getGenericInstantiation();
            return copy;
        }
        Map<TypeVariable<?>, Type> typeMap = ((GenericAccessibleObject)copy).getOwnerClass().getTypeVariableMap();
        logger.debug("Getting random generic instantiation of method: " + this.toString() + " with owner type map: " + typeMap);
        ArrayList<GenericClass> typeParameters = new ArrayList<GenericClass>();
        for (TypeVariable<?> parameter : this.getTypeParameters()) {
            GenericClass genericType = new GenericClass(parameter);
            GenericClass concreteType = genericType.getGenericInstantiation(typeMap);
            logger.debug("Setting parameter " + parameter + " to type " + concreteType.getTypeName());
            typeParameters.add(concreteType);
        }
        ((GenericAccessibleObject)copy).setTypeParameters(typeParameters);
        ((GenericAccessibleObject)copy).owner = ((GenericAccessibleObject)copy).getOwnerClass().getGenericInstantiation(typeMap);
        return copy;
    }

    public T getGenericInstantiation(GenericClass calleeType) throws ConstructionFailedException {
        T copy = this.copy();
        logger.debug("Getting generic instantiation for callee " + calleeType + " of method: " + this.toString() + " for callee " + calleeType);
        Map<TypeVariable<?>, Type> typeMap = calleeType.getTypeVariableMap();
        if (!this.hasTypeParameters()) {
            logger.debug("Have no type parameters, just using typeMap of callee");
            ((GenericAccessibleObject)copy).owner = ((GenericAccessibleObject)copy).getOwnerClass().getGenericInstantiation(typeMap);
            return copy;
        }
        ArrayList<GenericClass> typeParameters = new ArrayList<GenericClass>();
        for (TypeVariable<?> parameter : this.getTypeParameters()) {
            GenericClass concreteType = new GenericClass(parameter);
            logger.debug("(I) Setting parameter " + parameter + " to type " + concreteType.getTypeName());
            typeParameters.add(concreteType.getGenericInstantiation(typeMap));
        }
        ((GenericAccessibleObject)copy).setTypeParameters(typeParameters);
        ((GenericAccessibleObject)copy).owner = ((GenericAccessibleObject)copy).getOwnerClass().getGenericInstantiation(typeMap);
        return copy;
    }

    public T getGenericInstantiationFromReturnValue(GenericClass generatedType) throws ConstructionFailedException {
        logger.debug("Instantiating generic return for generated Type " + generatedType);
        T copy = this.copy();
        HashMap concreteTypes = new HashMap();
        logger.debug("Getting type map of generated type");
        Map<TypeVariable<?>, Type> generatorTypes = generatedType.getTypeVariableMap();
        logger.debug("Got type map of generated type: " + generatorTypes);
        Type genericReturnType = this.getGenericGeneratedType();
        logger.debug("Getting generic instantiation for return type " + generatedType + " of method: " + this.toString());
        if (genericReturnType instanceof ParameterizedType && generatedType.isParameterizedType()) {
            logger.debug("Return value is a parameterized type, matching variables");
            generatorTypes.putAll(GenericUtils.getMatchingTypeParameters((ParameterizedType)generatedType.getType(), (ParameterizedType)genericReturnType));
        } else if (genericReturnType instanceof TypeVariable) {
            generatorTypes.put((TypeVariable)genericReturnType, generatedType.getType());
        }
        if (genericReturnType instanceof ParameterizedType) {
            for (Type parameterType : this.getGenericParameterTypes()) {
                logger.debug("Checking parameter " + parameterType);
                if (!(parameterType instanceof ParameterizedType)) continue;
                Map<TypeVariable<?>, Type> matchedMap = GenericUtils.getMatchingTypeParameters((ParameterizedType)parameterType, (ParameterizedType)genericReturnType);
                for (TypeVariable<?> var : matchedMap.keySet()) {
                    if (generatorTypes.containsKey(var)) continue;
                    generatorTypes.put(var, matchedMap.get(var));
                }
                logger.debug("Map is now " + generatorTypes);
            }
        }
        logger.debug("GeneratorTypes is now: " + generatorTypes);
        List<TypeVariable<?>> parameters = Arrays.asList(this.getTypeParameters());
        for (TypeVariable<?> var : generatorTypes.keySet()) {
            if (parameters.contains(var) && !(generatorTypes.get(var) instanceof WildcardType)) {
                logger.debug("Parameter " + var + " in map, adding to concrete types: " + generatorTypes.get(var));
                concreteTypes.put(var, generatorTypes.get(var));
                continue;
            }
            logger.debug("Parameter " + var + " not in map, not adding to concrete types: " + generatorTypes.get(var));
            logger.debug("Key: " + var.getGenericDeclaration());
            for (TypeVariable<?> k : parameters) {
                logger.debug("Param: " + k.getGenericDeclaration());
            }
        }
        ArrayList<GenericClass> typeParameters = new ArrayList<GenericClass>();
        logger.debug("Setting parameters with map: " + concreteTypes);
        for (TypeVariable<?> parameter : this.getTypeParameters()) {
            GenericClass concreteType = new GenericClass(parameter);
            logger.debug("(I) Setting parameter " + parameter + " to type " + concreteType.getTypeName());
            GenericClass instantiation = concreteType.getGenericInstantiation(concreteTypes);
            logger.debug("Got instantiation for " + parameter + ": " + instantiation);
            if (!instantiation.satisfiesBoundaries(parameter, concreteTypes)) {
                logger.info("Type parameter does not satisfy boundaries: " + parameter + " " + instantiation);
                logger.info(Arrays.asList(parameter.getBounds()).toString());
                logger.info(instantiation.toString());
                throw new ConstructionFailedException("Type parameter does not satisfy boundaries: " + parameter);
            }
            typeParameters.add(instantiation);
        }
        ((GenericAccessibleObject)copy).setTypeParameters(typeParameters);
        ((GenericAccessibleObject)copy).owner = ((GenericAccessibleObject)copy).getOwnerClass().getGenericInstantiation(concreteTypes);
        return copy;
    }

    public abstract String getName();

    public int getNumParameters() {
        return 0;
    }

    public GenericClass getOwnerClass() {
        return this.owner;
    }

    public Type getOwnerType() {
        return this.owner.getType();
    }

    public abstract Class<?> getRawGeneratedType();

    public TypeVariable<?>[] getTypeParameters() {
        return new TypeVariable[0];
    }

    protected Map<TypeVariable<?>, GenericClass> getTypeVariableMap() {
        HashMap typeMap = new HashMap();
        int pos = 0;
        for (TypeVariable<?> variable : this.getTypeParameters()) {
            if (this.typeVariables.size() <= pos) break;
            typeMap.put(variable, this.typeVariables.get(pos));
            ++pos;
        }
        return typeMap;
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length != 0;
    }

    public abstract boolean isAccessible();

    public boolean isConstructor() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    protected Type mapTypeParameters(Type toMapType, Type typeAndParams) {
        if (GenericAccessibleObject.isMissingTypeParameters(typeAndParams)) {
            logger.debug("Is missing type parameters, so erasing types");
            return GenericTypeReflector.erase(toMapType);
        }
        VarMap varMap = new VarMap();
        Type handlingTypeAndParams = typeAndParams;
        while (handlingTypeAndParams instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)handlingTypeAndParams;
            Class clazz = (Class)pType.getRawType();
            varMap.addAll(clazz.getTypeParameters(), pType.getActualTypeArguments());
            handlingTypeAndParams = pType.getOwnerType();
        }
        varMap.addAll(this.getTypeVariableMap());
        return varMap.map(toMapType);
    }

    public void setTypeParameters(List<GenericClass> parameterTypes) {
        this.typeVariables.clear();
        for (GenericClass parameter : parameterTypes) {
            this.typeVariables.add(new GenericClass(parameter));
        }
    }

    public abstract String toString();
}

