/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.Serializable;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.testcase.TestCaseExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceController
implements SearchListener,
StoppingCondition,
Serializable {
    private static final long serialVersionUID = -4459807323163275506L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceController.class);
    private GeneticAlgorithm<?> ga;
    private boolean stopComputation;

    private boolean hasExceededResources() {
        if (TestCaseExecutor.getInstance().getNumStalledThreads() >= Properties.MAX_STALLED_THREADS) {
            logger.info("* Too many stalled threads: " + TestCaseExecutor.getInstance().getNumStalledThreads() + " / " + Properties.MAX_STALLED_THREADS);
            return true;
        }
        Runtime runtime = Runtime.getRuntime();
        long freeMem = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (freeMem < (long)Properties.MIN_FREE_MEM) {
            logger.trace("* Running out of memory, calling GC with memory left: " + freeMem + " / " + runtime.maxMemory());
            System.gc();
            freeMem = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
            if (freeMem < (long)Properties.MIN_FREE_MEM) {
                logger.info("* Running out of memory, giving up: " + freeMem + " / " + runtime.maxMemory() + " - need " + Properties.MIN_FREE_MEM);
                return true;
            }
            logger.trace("* Garbage collection recovered sufficient memory: " + freeMem + " / " + runtime.maxMemory());
        }
        return false;
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.ga = algorithm;
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
        if (this.hasExceededResources()) {
            this.stopComputation = true;
            this.ga.addStoppingCondition(this);
            logger.warn("Shutting down the search due to running out of computational resources");
        }
    }

    @Override
    public void modification(Chromosome individual) {
    }

    @Override
    public void forceCurrentValue(long value) {
    }

    @Override
    public long getCurrentValue() {
        return 0L;
    }

    @Override
    public long getLimit() {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.stopComputation;
    }

    @Override
    public void reset() {
        this.stopComputation = false;
    }

    @Override
    public void setLimit(long limit) {
    }
}

