/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename;

import java.util.Hashtable;
import java.util.Vector;

public class XMLElement2 {
    static final long serialVersionUID = 6685035139346394777L;
    public static final int NANOXML_MAJOR_VERSION = 2;
    public static final int NANOXML_MINOR_VERSION = 2;
    private Hashtable attributes;
    private Vector children;
    private String name;
    private String contents;
    private Hashtable entities;
    private int lineNr;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private String reader;
    private int readerIndex;
    private int parserLineNr;

    public static void testCase(String string0) {
        XMLElement2 xmlElement = new XMLElement2();
        xmlElement.parseString(string0);
    }

    public XMLElement2() {
        this(new Hashtable(), false, true, true);
    }

    private XMLElement2(Hashtable entities, boolean skipLeadingWhitespace, boolean fillBasicConversionTable, boolean ignoreCase) {
        this.ignoreWhitespace = skipLeadingWhitespace;
        this.ignoreCase = ignoreCase;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.entities = entities;
        this.lineNr = 0;
        this.entities.put("amp", new char[]{'&'});
        this.entities.put("quot", new char[]{'\"'});
        this.entities.put("apos", new char[]{'\''});
        this.entities.put("lt", new char[]{'<'});
        this.entities.put("gt", new char[]{'>'});
    }

    public String getName() {
        return this.name;
    }

    private boolean checkLiteral(String literal) {
        int length = literal.length();
        for (int i = 0; i < length; ++i) {
            if (this.readChar() == literal.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private char readChar() {
        if (this.charReadTooMuch != '\u0000') {
            char ch = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return ch;
        }
        if (this.readerIndex > this.reader.length() - 1) {
            throw this.unexpectedEndOfData();
        }
        char i = this.reader.charAt(this.readerIndex);
        ++this.readerIndex;
        if (i == '\n') {
            ++this.parserLineNr;
            return '\n';
        }
        return i;
    }

    private XMLParseException unexpectedEndOfData() {
        String msg = "Unexpected end of data reached";
        return new XMLParseException(this.getName(), this.parserLineNr, msg);
    }

    public void parseString(String string) throws XMLParseException {
        this.parseFromReader(string, 1);
    }

    private void parseFromReader(String reader, int startingLineNr) throws XMLParseException {
        char ch;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.readerIndex = 0;
        this.parserLineNr = startingLineNr;
        while (true) {
            if ((ch = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            ch = this.readChar();
            if (ch != '!' && ch != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(ch);
        this.scanElement(this);
    }

    private char scanWhitespace() {
        char ch;
        block3: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    private XMLParseException expectedInput(String charSet) {
        String msg = "Expected: " + charSet;
        return new XMLParseException(this.getName(), this.parserLineNr, msg);
    }

    private void skipSpecialTag(int bracketLevel) {
        char ch;
        int tagLevel = 1;
        char stringDelimiter = '\u0000';
        if (bracketLevel == 0) {
            ch = this.readChar();
            if (ch == '[') {
                ++bracketLevel;
            } else if (ch == '-') {
                ch = this.readChar();
                if (ch == '[') {
                    ++bracketLevel;
                } else if (ch == ']') {
                    --bracketLevel;
                } else if (ch == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (tagLevel > 0) {
            ch = this.readChar();
            if (stringDelimiter == '\u0000') {
                if (ch == '\"' || ch == '\'') {
                    stringDelimiter = ch;
                } else if (bracketLevel <= 0) {
                    if (ch == '<') {
                        ++tagLevel;
                    } else if (ch == '>') {
                        --tagLevel;
                    }
                }
                if (ch == '[') {
                    ++bracketLevel;
                    continue;
                }
                if (ch != ']') continue;
                --bracketLevel;
                continue;
            }
            if (ch != stringDelimiter) continue;
            stringDelimiter = '\u0000';
        }
    }

    private void unreadChar(char ch) {
        this.charReadTooMuch = ch;
    }

    private void scanElement(XMLElement2 elt) {
        char ch;
        String name;
        StringBuffer buf;
        block26: {
            buf = new StringBuffer();
            this.scanIdentifier(buf);
            name = buf.toString();
            if (name.length() == 0) {
                throw new XMLParseException("", "");
            }
            elt.setName(name);
            ch = this.scanWhitespace();
            while (ch != '>' && ch != '/') {
                buf = new StringBuffer();
                this.unreadChar(ch);
                this.scanIdentifier(buf);
                String key = buf.toString();
                ch = this.scanWhitespace();
                if (ch != '=') {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                buf = new StringBuffer();
                this.scanString(buf);
                if (key.length() == 0) {
                    throw new XMLParseException("", "");
                }
                elt.setAttribute(key, buf);
                ch = this.scanWhitespace();
            }
            if (ch == '/') {
                ch = this.readChar();
                if (ch != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            buf = new StringBuffer();
            ch = this.scanWhitespace(buf);
            if (ch != '<') {
                this.unreadChar(ch);
                this.scanPCData(buf);
            } else {
                while ((ch = this.readChar()) == '!') {
                    if (this.checkCDATA(buf)) {
                        this.scanPCData(buf);
                    } else {
                        ch = this.scanWhitespace(buf);
                        if (ch == '<') continue;
                        this.unreadChar(ch);
                        this.scanPCData(buf);
                    }
                    break block26;
                }
                if (ch != '/' || this.ignoreWhitespace) {
                    buf = new StringBuffer();
                }
                if (ch == '/') {
                    this.unreadChar(ch);
                }
            }
        }
        if (buf.length() == 0) {
            while (ch != '/') {
                if (ch == '!') {
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(ch);
                    XMLElement2 child = this.createAnotherElement();
                    this.scanElement(child);
                    elt.addChild(child);
                }
                ch = this.scanWhitespace();
                if (ch != '<') {
                    throw this.expectedInput("<");
                }
                ch = this.readChar();
            }
            this.unreadChar(ch);
        } else if (this.ignoreWhitespace) {
            elt.setContent(buf.toString().trim());
        } else {
            elt.setContent(buf.toString());
        }
        ch = this.readChar();
        if (ch != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(name)) {
            throw this.expectedInput(name);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    private void skipComment() {
        int dashesToRead = 2;
        while (dashesToRead > 0) {
            char ch = this.readChar();
            if (ch == '-') {
                --dashesToRead;
                continue;
            }
            dashesToRead = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    private void scanIdentifier(StringBuffer result) {
        while (true) {
            char ch;
            if (!((ch = this.readChar()) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-' || ch > '~')) {
                this.unreadChar(ch);
                return;
            }
            result.append(ch);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    private void scanString(StringBuffer string) {
        char delimiter = this.readChar();
        if (delimiter != '\'' && delimiter != '\"') {
            throw this.expectedInput("' or \"");
        }
        char ch;
        while ((ch = this.readChar()) != delimiter) {
            if (ch == '&') {
                this.resolveEntity(string);
                continue;
            }
            string.append(ch);
        }
        return;
    }

    private void resolveEntity(StringBuffer buf) {
        char ch = '\u0000';
        StringBuffer keyBuf = new StringBuffer();
        while ((ch = this.readChar()) != ';') {
            keyBuf.append(ch);
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            try {
                ch = key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10);
            }
            catch (NumberFormatException e) {
                throw this.unknownEntity(key);
            }
            buf.append(ch);
        } else {
            char[] value = (char[])this.entities.get(key);
            if (value == null) {
                throw this.unknownEntity(key);
            }
            buf.append(value);
        }
    }

    private XMLParseException unknownEntity(String name) {
        String msg = "Unknown or invalid entity: &" + name + ";";
        return new XMLParseException(this.getName(), this.parserLineNr, msg);
    }

    public void setAttribute(String name, Object value) {
        if (this.ignoreCase) {
            name = name.toUpperCase();
        }
        this.attributes.put(name, value.toString());
    }

    private char scanWhitespace(StringBuffer result) {
        char ch;
        block4: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case ' ': {
                    result.append(ch);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return ch;
    }

    private void scanPCData(StringBuffer data) {
        while (true) {
            char ch;
            if ((ch = this.readChar()) == '<') {
                ch = this.readChar();
                if (ch == '!') {
                    this.checkCDATA(data);
                    continue;
                }
                this.unreadChar(ch);
                return;
            }
            if (ch == '&') {
                this.resolveEntity(data);
                continue;
            }
            data.append(ch);
        }
    }

    private boolean checkCDATA(StringBuffer buf) {
        char ch = this.readChar();
        if (ch != '[') {
            this.unreadChar(ch);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int delimiterCharsSkipped = 0;
        block4: while (delimiterCharsSkipped < 3) {
            int i;
            ch = this.readChar();
            switch (ch) {
                case ']': {
                    if (delimiterCharsSkipped < 2) {
                        ++delimiterCharsSkipped;
                        continue block4;
                    }
                    buf.append(']');
                    buf.append(']');
                    delimiterCharsSkipped = 0;
                    continue block4;
                }
                case '>': {
                    if (delimiterCharsSkipped < 2) {
                        for (i = 0; i < delimiterCharsSkipped; ++i) {
                            buf.append(']');
                        }
                        delimiterCharsSkipped = 0;
                        buf.append('>');
                        continue block4;
                    }
                    delimiterCharsSkipped = 3;
                    continue block4;
                }
            }
            for (i = 0; i < delimiterCharsSkipped; ++i) {
                buf.append(']');
            }
            buf.append(ch);
            delimiterCharsSkipped = 0;
        }
        return true;
    }

    private XMLElement2 createAnotherElement() {
        return new XMLElement2(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public void setContent(String content) {
        this.contents = content;
    }

    public void addChild(XMLElement2 child) {
        this.children.addElement(child);
    }

    public static class XMLParseException
    extends RuntimeException {
        public XMLParseException(String msg, int line, String ex) {
        }

        public XMLParseException(String msg, String ex) {
        }
    }
}

