/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.testcarver;

import com.examples.with.different.packagename.testcarver.ConversionException;
import com.examples.with.different.packagename.testcarver.Converter;
import java.lang.reflect.Array;
import java.util.Collection;

public abstract class AbstractConverter
implements Converter {
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils.converters.";
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public Object convert(Class type, Object value) {
        Class<?> sourceType = value == null ? null : value.getClass();
        Class targetType = this.primitive(type == null ? this.getDefaultType() : type);
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value.getClass();
        try {
            if (targetType.equals(String.class)) {
                return this.convertToString(value);
            }
            if (targetType.equals(sourceType)) {
                return value;
            }
            Object result = this.convertToType(targetType, value);
            return result;
        }
        catch (Throwable t) {
            return this.handleError(targetType, value, t);
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract Object convertToType(Class var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected Object handleError(Class type, Object value, Throwable cause) {
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
        } else {
            String msg = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
        }
        throw cex;
    }

    protected Object handleMissing(Class type) {
        if (this.useDefault || type.equals(String.class)) {
            Object value = this.getDefault(type);
            if (this.useDefault && value != null && !type.equals(value.getClass())) {
                try {
                    value = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable t) {
                    System.err.println("    Default conversion to " + this.toString(type) + "failed: " + t);
                }
            }
            return value;
        }
        ConversionException cex = new ConversionException("No value specified for '" + this.toString(type) + "'");
        throw cex;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class getDefaultType();

    protected Object getDefault(Class type) {
        if (type.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    Class primitive(Class type) {
        if (type == null || !type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    String toString(Class type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }
}

