/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.testcarver;

import com.examples.with.different.packagename.testcarver.ConversionException;
import com.examples.with.different.packagename.testcarver.Converter;
import com.examples.with.different.packagename.testcarver.DateConverter;
import com.examples.with.different.packagename.testcarver.DateTimeConverter;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class DateConverterTest11 {
    protected DateTimeConverter makeConverter() {
        return new DateConverter();
    }

    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new DateConverter(defaultValue);
    }

    protected Class<?> getExpectedType() {
        return Date.class;
    }

    long getTimeInMillis(Object date) {
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return timeInMillis += (long)(timestamp.getNanos() / 1000000);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        return ((Date)date).getTime();
    }

    void validConversion(Converter converter, Object expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        try {
            Object result = converter.convert(this.getExpectedType(), value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            Assert.assertEquals((String)("TYPE " + msg), expectType, resultType);
            Assert.assertEquals((String)("VALUE " + msg), (Object)expected, (Object)result);
        }
        catch (Exception ex) {
            Assert.fail((String)(msg + " threw " + ex.toString()));
        }
    }

    void stringConversion(Converter converter, String expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "' to String";
        try {
            Object result = converter.convert(String.class, value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            Assert.assertEquals((String)("TYPE " + msg), expectType, resultType);
            Assert.assertEquals((String)("VALUE " + msg), (Object)expected, (Object)result);
        }
        catch (Exception ex) {
            Assert.fail((String)(msg + " threw " + ex.toString()));
        }
    }

    void invalidConversion(Converter converter, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        try {
            Object result = converter.convert(this.getExpectedType(), value);
            Assert.fail((String)(msg + ", expected ConversionException, but result = '" + result + "'"));
        }
        catch (ConversionException ex) {
            // empty catch block
        }
    }

    Object toType(String value, String pattern, Locale locale) {
        Calendar calendar = this.toCalendar(value, pattern, locale);
        return this.toType(calendar);
    }

    Calendar toCalendar(String value, String pattern, Locale locale) {
        Calendar calendar = null;
        try {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
            format.setLenient(false);
            format.parse(value);
            calendar = format.getCalendar();
        }
        catch (Exception e) {
            Assert.fail((String)("Error creating Calendar value ='" + value + ", pattern='" + pattern + "' " + e.toString()));
        }
        return calendar;
    }

    Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    java.sql.Date toSqlDate(Calendar calendar) {
        return new java.sql.Date(this.getTimeInMillis(calendar));
    }

    Time toSqlTime(Calendar calendar) {
        return new Time(this.getTimeInMillis(calendar));
    }

    Timestamp toSqlTimestamp(Calendar calendar) {
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    protected Object toType(Calendar value) {
        return value.getTime();
    }

    @Test
    public void testInvalidType() {
        DateTimeConverter converter = this.makeConverter();
        try {
            converter.convert(Character.class, new Date());
            Assert.fail((String)"Requested Character.class conversion, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

