/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.testcarver;

import com.examples.with.different.packagename.testcarver.DateConverter;
import com.examples.with.different.packagename.testcarver.DateTimeConverter;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.Assert;
import org.junit.Test;

public class DateConverterTest2 {
    protected DateTimeConverter makeConverter() {
        return new DateConverter();
    }

    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new DateConverter(defaultValue);
    }

    protected Class<?> getExpectedType() {
        return Date.class;
    }

    long getTimeInMillis(Object date) {
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return timeInMillis += (long)(timestamp.getNanos() / 1000000);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        return ((Date)date).getTime();
    }

    @Test
    public void testConvertDate() {
        String[] message = new String[]{"from Date", "from Calendar", "from SQL Date", "from SQL Time", "from SQL Timestamp"};
        long now = System.currentTimeMillis();
        Object[] date = new Object[]{new Date(now), new GregorianCalendar(), new java.sql.Date(now), new Time(now), new Timestamp(now)};
        ((GregorianCalendar)date[1]).setTime(new Date(now));
        for (int i = 0; i < date.length; ++i) {
            Object val = this.makeConverter().convert(this.getExpectedType(), date[i]);
            Assert.assertNotNull((String)("Convert " + message[i] + " should not be null"), (Object)val);
            Assert.assertTrue((String)("Convert " + message[i] + " should return a " + this.getExpectedType().getName()), (boolean)this.getExpectedType().isInstance(val));
            Assert.assertEquals((String)("Convert " + message[i] + " should return a " + date[0]), (long)now, (long)this.getTimeInMillis(val));
        }
    }
}

