/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.testcarver;

import com.examples.with.different.packagename.testcarver.ConversionException;
import com.examples.with.different.packagename.testcarver.DateConverter;
import com.examples.with.different.packagename.testcarver.DateTimeConverter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class DateConverterTest4 {
    protected DateTimeConverter makeConverter() {
        return new DateConverter();
    }

    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new DateConverter(defaultValue);
    }

    protected Class<?> getExpectedType() {
        return Date.class;
    }

    long getTimeInMillis(Object date) {
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return timeInMillis += (long)(timestamp.getNanos() / 1000000);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        return ((Date)date).getTime();
    }

    Calendar toCalendar(String value, String pattern, Locale locale) {
        Calendar calendar = null;
        try {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
            format.setLenient(false);
            format.parse(value);
            calendar = format.getCalendar();
        }
        catch (Exception e) {
            Assert.fail((String)("Error creating Calendar value ='" + value + ", pattern='" + pattern + "' " + e.toString()));
        }
        return calendar;
    }

    Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    Object toType(String value, String pattern, Locale locale) {
        Calendar calendar = this.toCalendar(value, pattern, locale);
        return this.toType(calendar);
    }

    protected Object toType(Calendar value) {
        return value.getTime();
    }

    @Test
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        try {
            converter.convert(this.getExpectedType(), "2006-10-23");
            Assert.fail((String)"Expected Conversion exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

