/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.testcarver;

import com.examples.with.different.packagename.testcarver.Converter;
import com.examples.with.different.packagename.testcarver.DateConverter;
import com.examples.with.different.packagename.testcarver.DateTimeConverter;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class DateConverterTest5 {
    protected DateTimeConverter makeConverter() {
        return new DateConverter();
    }

    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new DateConverter(defaultValue);
    }

    protected Class<?> getExpectedType() {
        return Date.class;
    }

    long getTimeInMillis(Object date) {
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return timeInMillis += (long)(timestamp.getNanos() / 1000000);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        return ((Date)date).getTime();
    }

    Calendar toCalendar(String value, String pattern, Locale locale) {
        Calendar calendar = null;
        try {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
            format.setLenient(false);
            format.parse(value);
            calendar = format.getCalendar();
        }
        catch (Exception e) {
            Assert.fail((String)("Error creating Calendar value ='" + value + ", pattern='" + pattern + "' " + e.toString()));
        }
        return calendar;
    }

    Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    Object toType(String value, String pattern, Locale locale) {
        Calendar calendar = this.toCalendar(value, pattern, locale);
        return this.toType(calendar);
    }

    protected Object toType(Calendar value) {
        return value.getTime();
    }

    java.sql.Date toSqlDate(Calendar calendar) {
        return new java.sql.Date(this.getTimeInMillis(calendar));
    }

    Time toSqlTime(Calendar calendar) {
        return new Time(this.getTimeInMillis(calendar));
    }

    Timestamp toSqlTimestamp(Calendar calendar) {
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    void stringConversion(Converter converter, String expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "' to String";
        try {
            Object result = converter.convert(String.class, value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            Assert.assertEquals((String)("TYPE " + msg), expectType, resultType);
            Assert.assertEquals((String)("VALUE " + msg), (Object)expected, (Object)result);
        }
        catch (Exception ex) {
            Assert.fail((String)(msg + " threw " + ex.toString()));
        }
    }

    @Test
    public void testStringConversion() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter converter = this.makeConverter();
        converter.setPattern(pattern);
        String expected = "2006-10-29";
        Calendar calendar = this.toCalendar(expected, pattern, null);
        this.stringConversion(converter, expected, this.toType(calendar));
        this.stringConversion(converter, expected, calendar);
        this.stringConversion(converter, expected, this.toDate(calendar));
        this.stringConversion(converter, expected, this.toSqlDate(calendar));
        this.stringConversion(converter, expected, this.toSqlTimestamp(calendar));
        this.stringConversion(converter, expected, this.toSqlTime(calendar));
        this.stringConversion(converter, null, null);
        this.stringConversion(converter, "", "");
    }
}

