/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.reset.ResetManager;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.evosuite.utils.Randomness;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SystemTest {
    public static final String ALREADY_SETUP = "systemtest.alreadysetup";
    private static java.util.Properties currentProperties;
    private static boolean hasBeenAlreadyRun;

    @After
    public void resetStaticVariables() {
        TestGenerationContext.getInstance().resetContext();
        ResetManager.getInstance().clearManager();
        System.setProperties(currentProperties);
        Properties.getInstance().resetToDefaults();
    }

    @Before
    public void setDefaultPropertiesForTestCases() {
        Properties.getInstance().resetToDefaults();
        Properties.HTML = false;
        Properties.SHOW_PROGRESS = false;
        Properties.SERIALIZE_RESULT = false;
        Properties.JUNIT_TESTS = false;
        Properties.PLOT = false;
        Properties.STOPPING_CONDITION = Properties.StoppingCondition.MAXSTATEMENTS;
        Properties.SEARCH_BUDGET = 10000L;
        Properties.GLOBAL_TIMEOUT = 120;
        Properties.MINIMIZATION_TIMEOUT = 8;
        Properties.EXTRA_TIMEOUT = 2;
        Properties.ENABLE_ASSERTS_FOR_EVOSUITE = true;
        Properties.CLIENT_ON_THREAD = true;
        Properties.SANDBOX = false;
        Properties.ERROR_BRANCHES = false;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.BRANCH};
        Properties.NEW_STATISTICS = true;
        Properties.STATISTICS_BACKEND = Properties.StatisticsBackend.DEBUG;
        TestGenerationContext.getInstance().resetContext();
        ResetManager.getInstance().clearManager();
        Randomness.setSeed((long)42L);
        currentProperties = (java.util.Properties)System.getProperties().clone();
        MockFramework.enable();
    }

    protected void checkUnstable() throws IllegalStateException {
        if (!Properties.OUTPUT_VARIABLES.contains(RuntimeVariable.HadUnstableTests.toString())) {
            throw new IllegalStateException("Properties.OUTPUT_VARIABLES needs to contain RuntimeVariable.HadUnstableTests");
        }
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable unstable = (OutputVariable)map.get(RuntimeVariable.HadUnstableTests.toString());
        Assert.assertNotNull((Object)unstable);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)unstable.getValue());
    }

    private static void runSetup() {
        if (hasBeenAlreadyRun) {
            return;
        }
        SystemTest.deleteEvoDirs();
        System.out.println("*** SystemTest: runSetup() ***");
        String master = SystemTest.getMasterTestsTarget();
        String runtime = SystemTest.getRuntimeTestsTarget();
        String client = SystemTest.getClientTestsTarget();
        EvoSuite evosuite = new EvoSuite();
        String[] command = new String[]{"-setup", master, runtime, client};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertNull((Object)result);
        File evoProp = new File(Properties.OUTPUT_DIR + File.separator + "evosuite.properties");
        Assert.assertTrue((String)("It was not created: " + evoProp.getAbsolutePath()), (boolean)evoProp.exists());
        hasBeenAlreadyRun = true;
    }

    private static String getMasterTestsTarget() {
        String target = System.getProperty("user.dir") + File.separator + "target" + File.separator + "test-classes";
        SystemTest.checkFile(target);
        return target;
    }

    private static String getRuntimeTestsTarget() {
        String target = System.getProperty("user.dir") + File.separator + ".." + File.separator + "runtime" + File.separator + "target" + File.separator + "test-classes";
        SystemTest.checkFile(target);
        return target;
    }

    private static String getClientTestsTarget() {
        String target = System.getProperty("user.dir") + File.separator + ".." + File.separator + "client" + File.separator + "target" + File.separator + "test-classes";
        SystemTest.checkFile(target);
        return target;
    }

    private static void checkFile(String target) {
        File targetDir = new File(target);
        try {
            Assert.assertTrue((String)("Target directory does not exist: " + targetDir.getCanonicalPath()), (boolean)targetDir.exists());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)targetDir.isDirectory());
    }

    private static void deleteEvoDirs() {
        System.out.println("*** SystemTest: deleteEvoDirs() ***");
        try {
            FileUtils.deleteDirectory((File)new File("evosuite-files"));
            FileUtils.deleteDirectory((File)new File("evosuite-report"));
            FileUtils.deleteDirectory((File)new File("evosuite-tests"));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        hasBeenAlreadyRun = false;
    }

    protected GeneticAlgorithm<?> getGAFromResult(Object result) {
        assert (result instanceof List);
        List results = (List)result;
        assert (results.size() == 1);
        return ((TestGenerationResult)((List)results.get(0)).get(0)).getGeneticAlgorithm();
    }

    static {
        String s = System.getProperty(ALREADY_SETUP);
        if (s == null) {
            System.setProperty(ALREADY_SETUP, ALREADY_SETUP);
            SystemTest.runSetup();
        }
        hasBeenAlreadyRun = false;
    }
}

