/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import com.examples.with.different.packagename.Compositional;
import com.examples.with.different.packagename.defuse.DefUseExample1;
import com.examples.with.different.packagename.defuse.GCD;
import java.util.Map;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.statement.StatementCoverageSuiteFitness;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompositionalFitness
extends SystemTest {
    private final double ANY_DOUBLE_1 = 2.0;
    private final double ANY_DOUBLE_2 = 5.0;
    private final double ANY_DOUBLE_3 = 6.0;
    private final double ANY_DOUBLE_4 = 3.0;
    private static final Properties.Criterion[] defaultCriterion = Properties.CRITERION;

    @Before
    public void beforeTest() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = true;
        Properties.LOG_LEVEL = "debug";
        Properties.PRINT_TO_SYSTEM = true;
        Properties.CLIENT_ON_THREAD = true;
        Properties.ASSERTIONS = false;
    }

    @After
    public void afterTest() {
        Properties.CRITERION = defaultCriterion;
    }

    @Test
    public void testCompositionalTwoFunction() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DefUseExample1.class.getCanonicalName();
        Properties.CRITERION = new Properties.Criterion[2];
        Properties.CRITERION[0] = Properties.Criterion.DEFUSE;
        Properties.CRITERION[1] = Properties.Criterion.METHODNOEXCEPTION;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Map fitnesses = best.getFitnesses();
        double sum = 0.0;
        double cov = 0.0;
        for (FitnessFunction fitness : fitnesses.keySet()) {
            sum += ((Double)fitnesses.get(fitness)).doubleValue();
            cov += best.getCoverage(fitness);
            assert (((Double)fitnesses.get(fitness)).doubleValue() == best.getFitness(fitness));
        }
        Assert.assertEquals((String)"Inconsistent fitness: ", (double)sum, (double)best.getFitness(), (double)0.001);
        Assert.assertEquals((String)"Inconsistent coverage: ", (double)(cov /= (double)best.getCoverages().size()), (double)best.getCoverage(), (double)0.001);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testGCDExample() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = GCD.class.getCanonicalName();
        Properties.CRITERION = new Properties.Criterion[2];
        Properties.CRITERION[0] = Properties.Criterion.ONLYBRANCH;
        Properties.CRITERION[1] = Properties.Criterion.ONLYMUTATION;
        Properties.ANALYSIS_CRITERIA = "OnlyBranch,ONLYMUTATION,METHOD,exception";
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testGetFitnessForNoFunctionNoCompositional() {
        Properties.COMPOSITIONAL_FITNESS = false;
        TestSuiteChromosome c = new TestSuiteChromosome();
        Assert.assertEquals((double)0.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForNoFunction() {
        TestSuiteChromosome c = new TestSuiteChromosome();
        Assert.assertEquals((double)0.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForOneFunction() {
        TestSuiteChromosome c = new TestSuiteChromosome();
        StatementCoverageSuiteFitness f1 = new StatementCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.setFitness((FitnessFunction)f1, 2.0);
        Assert.assertEquals((double)2.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForTwoFunctions() {
        TestSuiteChromosome c = new TestSuiteChromosome();
        StatementCoverageSuiteFitness f1 = new StatementCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.setFitness((FitnessFunction)f1, 2.0);
        BranchCoverageSuiteFitness f2 = new BranchCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f2);
        c.setFitness((FitnessFunction)f2, 5.0);
        Assert.assertEquals((double)7.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForSeveralFunctions() {
        Properties.TARGET_CLASS = Compositional.class.getCanonicalName();
        TestSuiteChromosome c = new TestSuiteChromosome();
        MethodTraceCoverageSuiteFitness f1 = new MethodTraceCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.setFitness((FitnessFunction)f1, 2.0);
        MethodNoExceptionCoverageSuiteFitness f2 = new MethodNoExceptionCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f2);
        c.setFitness((FitnessFunction)f2, 5.0);
        OutputCoverageSuiteFitness f3 = new OutputCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f3);
        c.setFitness((FitnessFunction)f3, 6.0);
        ExceptionCoverageSuiteFitness f4 = new ExceptionCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f4);
        c.setFitness((FitnessFunction)f4, 3.0);
        double sum = 16.0;
        Assert.assertEquals((double)sum, (double)c.getFitness(), (double)0.001);
    }
}

