/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import com.examples.with.different.packagename.IntegerCollectionAllBranch;
import com.examples.with.different.packagename.IntegerContainerBranch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerTransformation
extends SystemTest {
    @Test
    public void testContainsTransformation() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)17));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)626));
        Assert.assertTrue((BooleanHelper.collectionContains(firstSet, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsTransformationList() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(17);
        list.add(626);
        list.add(17);
        Assert.assertEquals((long)2L, (long)BooleanHelper.collectionContains(list, (Object)17));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(list, (Object)626));
        Assert.assertTrue((BooleanHelper.collectionContains(list, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsStringTransformation() {
        HashSet<String> firstSet = new HashSet<String>();
        firstSet.add("foo");
        firstSet.add("bar");
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)"foo"));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)"bar"));
        Assert.assertTrue((BooleanHelper.collectionContains(firstSet, (Object)"zoo") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsStringTransformationList() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("foo");
        list.add("bar");
        list.add("foo");
        Assert.assertEquals((long)2L, (long)BooleanHelper.collectionContains(list, (Object)"foo"));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(list, (Object)"bar"));
        Assert.assertTrue((BooleanHelper.collectionContains(list, (Object)"zoo") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsAllTransformation() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)17));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(firstSet, (Object)626));
        Assert.assertTrue((BooleanHelper.collectionContains(firstSet, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsAllTransformationList() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(17);
        list.add(626);
        list.add(17);
        Assert.assertEquals((long)2L, (long)BooleanHelper.collectionContains(list, (Object)17));
        Assert.assertEquals((long)1L, (long)BooleanHelper.collectionContains(list, (Object)626));
        Assert.assertTrue((BooleanHelper.collectionContains(list, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCollectionEmptyTransformation2() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)-2L, (long)BooleanHelper.collectionIsEmpty(firstSet));
    }

    @Test
    public void testCollectionEmptyTransformation1() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("test");
        Assert.assertEquals((long)-1L, (long)BooleanHelper.collectionIsEmpty(list));
    }

    @Test
    public void testCollectionEmptyTransformation0() {
        HashSet firstSet = new HashSet();
        Assert.assertEquals((long)0x7FFFFFFDL, (long)BooleanHelper.collectionIsEmpty(firstSet));
    }

    @Test
    public void testMapContainsKeyTransformation() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(17, 235235);
        map.put(23, 233);
        Assert.assertEquals((long)1L, (long)BooleanHelper.mapContainsKey(map, (Object)17));
        Assert.assertEquals((long)1L, (long)BooleanHelper.mapContainsKey(map, (Object)23));
        Assert.assertTrue((BooleanHelper.mapContainsKey(map, (Object)24) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMapContainsValueTransformation() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(17, 235235);
        map.put(23, 233);
        Assert.assertEquals((long)1L, (long)BooleanHelper.mapContainsValue(map, (Object)235235));
        Assert.assertEquals((long)1L, (long)BooleanHelper.mapContainsValue(map, (Object)233));
        Assert.assertTrue((BooleanHelper.mapContainsValue(map, (Object)24) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerList() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntegerContainerBranch.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 80000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)5L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testIntegerListList() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntegerCollectionAllBranch.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 180000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)5L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }
}

