/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import com.examples.with.different.packagename.ExampleFieldClass;
import com.examples.with.different.packagename.ExampleInheritedClass;
import com.examples.with.different.packagename.test.AbsTest;
import com.examples.with.different.packagename.test.ArrayTest;
import com.examples.with.different.packagename.test.AssignmentTest;
import com.examples.with.different.packagename.test.CallTest;
import com.examples.with.different.packagename.test.DepTest;
import com.examples.with.different.packagename.test.EmptyTest;
import com.examples.with.different.packagename.test.EnumTest;
import com.examples.with.different.packagename.test.EnumTest2;
import com.examples.with.different.packagename.test.ExampleComplexReturnClass;
import com.examples.with.different.packagename.test.ExampleObserverClass;
import com.examples.with.different.packagename.test.ExampleStaticVoidSetterClass;
import com.examples.with.different.packagename.test.FieldTest;
import com.examples.with.different.packagename.test.MemberClass;
import com.examples.with.different.packagename.test.ObjectTest;
import com.examples.with.different.packagename.test.ObserverTest;
import com.examples.with.different.packagename.test.PolyExample;
import com.examples.with.different.packagename.test.StaticFieldTest;
import com.examples.with.different.packagename.test.SwitchTest;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Assert;
import org.junit.Test;

public class TestRegression
extends SystemTest {
    private GeneticAlgorithm<?> runTest(String targetClass) {
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass;
        Properties.SEARCH_BUDGET = 100000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        return ga;
    }

    private void testCovered(String targetClass, int numGoals) {
        GeneticAlgorithm<?> ga = this.runTest(targetClass);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println(best.toString());
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
        Assert.assertEquals((String)"Wrong number of target goals", (long)numGoals, (long)best.getNumOfCoveredGoals());
        Assert.assertEquals((String)"Wrong fitness: ", (double)0.0, (double)best.getFitness(), (double)0.0);
        Assert.assertTrue((String)"Wrong number of statements: ", (best.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAbs() {
        this.testCovered(AbsTest.class.getCanonicalName(), 3);
    }

    @Test
    public void testArray() {
        this.testCovered(ArrayTest.class.getCanonicalName(), 9);
    }

    @Test
    public void testAssignment() {
        Properties.CLASS_PREFIX = AssignmentTest.class.getCanonicalName().substring(0, AssignmentTest.class.getCanonicalName().lastIndexOf(46));
        this.testCovered(AssignmentTest.class.getCanonicalName(), 12);
    }

    @Test
    public void testCall() {
        this.testCovered(CallTest.class.getCanonicalName(), 3);
    }

    @Test
    public void testDependency() {
        this.testCovered(DepTest.class.getCanonicalName(), 2);
    }

    @Test
    public void testEmpty() {
        this.testCovered(EmptyTest.class.getCanonicalName(), 2);
    }

    @Test
    public void testEnum() {
        this.testCovered(EnumTest.class.getCanonicalName(), 6);
    }

    @Test
    public void testEnum2() {
        this.testCovered(EnumTest2.class.getCanonicalName(), 4);
    }

    @Test
    public void testComplexReturn() {
        this.testCovered(ExampleComplexReturnClass.class.getCanonicalName(), 3);
    }

    @Test
    public void testFieldClass() {
        this.testCovered(ExampleFieldClass.class.getCanonicalName(), 2);
    }

    @Test
    public void testInheritedClass() {
        this.testCovered(ExampleInheritedClass.class.getCanonicalName(), 3);
    }

    @Test
    public void testObserverClass() {
        this.testCovered(ExampleObserverClass.class.getCanonicalName(), 3);
    }

    @Test
    public void testStaticVoidSetter() {
        this.testCovered(ExampleStaticVoidSetterClass.class.getCanonicalName(), 2);
    }

    @Test
    public void testField() {
        this.testCovered(FieldTest.class.getCanonicalName(), 8);
    }

    @Test
    public void testMember() {
        this.testCovered(MemberClass.class.getCanonicalName(), 10);
    }

    @Test
    public void testObject() {
        this.testCovered(ObjectTest.class.getCanonicalName(), 5);
    }

    @Test
    public void testObserver() {
        this.testCovered(ObserverTest.class.getCanonicalName(), 3);
    }

    @Test
    public void testPoly() {
        this.testCovered(PolyExample.class.getCanonicalName(), 5);
    }

    @Test
    public void testStaticField() {
        this.testCovered(StaticFieldTest.class.getCanonicalName(), 5);
    }

    @Test
    public void testSwitch() {
        this.testCovered(SwitchTest.class.getCanonicalName(), 11);
    }
}

