/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import com.examples.with.different.packagename.InfiniteLoops;
import com.examples.with.different.packagename.PrintingThatShouldBeMuted;
import com.examples.with.different.packagename.StaticPrinting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestSUTPrintingThatShouldBeMuted
extends SystemTest {
    public static final int defaultTimeout = Properties.TIMEOUT;
    public static final boolean defaultPrintToSystem = Properties.PRINT_TO_SYSTEM;
    public static final PrintStream defaultOut = System.out;

    @After
    public void resetProperties() {
        Properties.TIMEOUT = defaultTimeout;
        Properties.PRINT_TO_SYSTEM = defaultPrintToSystem;
        System.setOut(defaultOut);
        Properties.CLIENT_ON_THREAD = true;
    }

    public void checkIfMuted(String targetClass, String msgSUT) {
        Properties.CLIENT_ON_THREAD = false;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream byteOut = new PrintStream(byteStream);
        System.setOut(byteOut);
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass;
        Properties.TIMEOUT = 300;
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        evosuite.parseCommandLine(command);
        String printed = byteStream.toString();
        Assert.assertTrue((String)("PRINTED:\n" + printed), (boolean)printed.contains("Starting client"));
        Assert.assertTrue((String)("PRINTED:\n" + printed), (boolean)printed.contains(msgSUT));
        command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=false"};
        byteStream.reset();
        evosuite.parseCommandLine(command);
        printed = byteStream.toString();
        Assert.assertTrue((String)("PRINTED:\n" + printed), (boolean)printed.contains("Starting client"));
        Assert.assertFalse((String)("PRINTED:\n" + printed), (boolean)printed.contains(msgSUT));
        Assert.assertFalse((String)("PRINTED:\n" + printed), (boolean)printed.contains("ERROR"));
    }

    @Test
    public void testBase() throws IOException {
        this.checkIfMuted(PrintingThatShouldBeMuted.class.getCanonicalName(), "Greater");
    }

    @Test
    public void testStatic() throws IOException {
        this.checkIfMuted(StaticPrinting.class.getCanonicalName(), "this should not be printed");
    }

    @Ignore
    @Test
    public void testInfiniteLoops() throws IOException {
        this.checkIfMuted(InfiniteLoops.class.getCanonicalName(), "This should not be printed");
    }
}

