/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import com.examples.with.different.packagename.assertion.ArrayObjects;
import com.examples.with.different.packagename.assertion.ArrayPrimitiveWrapper;
import com.examples.with.different.packagename.assertion.WrapperCreatingCopy;
import com.examples.with.different.packagename.assertion.WrapperExample;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.SameAssertion;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSameAssertion
extends SystemTest {
    private Properties.AssertionStrategy strategy = null;

    @Before
    public void storeAssertionStrategy() {
        this.strategy = Properties.ASSERTION_STRATEGY;
    }

    @After
    public void restoreAssertionStrategy() {
        Properties.ASSERTION_STRATEGY = this.strategy;
    }

    @Test
    public void testPrimitiveArray() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ArrayPrimitiveWrapper.class.getCanonicalName();
        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        boolean hasSameAssertion = false;
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        for (TestChromosome testChromosome : best.getTestChromosomes()) {
            for (Assertion assertion : testChromosome.getTestCase().getAssertions()) {
                if (!(assertion instanceof SameAssertion)) continue;
                hasSameAssertion = true;
                Assert.assertEquals((Object)true, (Object)((SameAssertion)assertion).value);
            }
        }
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertFalse((boolean)hasSameAssertion);
    }

    @Test
    public void testObjectArray() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ArrayObjects.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 100000L;
        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        boolean hasSameAssertion = false;
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        for (TestChromosome testChromosome : best.getTestChromosomes()) {
            for (Assertion assertion : testChromosome.getTestCase().getAssertions()) {
                if (!(assertion instanceof SameAssertion)) continue;
                hasSameAssertion = true;
                Assert.assertEquals((Object)false, (Object)((SameAssertion)assertion).value);
            }
        }
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((boolean)hasSameAssertion);
    }

    @Test
    public void testWrapper() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = WrapperExample.class.getCanonicalName();
        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        boolean hasSameAssertion = false;
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        for (TestChromosome testChromosome : best.getTestChromosomes()) {
            for (Assertion assertion : testChromosome.getTestCase().getAssertions()) {
                if (!(assertion instanceof SameAssertion)) continue;
                hasSameAssertion = true;
                Assert.assertEquals((Object)true, (Object)((SameAssertion)assertion).value);
            }
        }
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((boolean)hasSameAssertion);
    }

    @Test
    public void testWrapperCopy() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = WrapperCreatingCopy.class.getCanonicalName();
        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        boolean hasSameAssertion = false;
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        for (TestChromosome testChromosome : best.getTestChromosomes()) {
            for (Assertion assertion : testChromosome.getTestCase().getAssertions()) {
                if (!(assertion instanceof SameAssertion)) continue;
                hasSameAssertion = true;
                Assert.assertEquals((Object)false, (Object)((SameAssertion)assertion).value);
            }
        }
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((boolean)hasSameAssertion);
    }
}

