/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion.purity;

import com.examples.with.different.packagename.purity.ImpureInspector;
import java.util.Map;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.objectweb.asm.Type;

public class TestImpureInspector
extends SystemTest {
    private final boolean DEFAULT_RESET_STATIC_FIELDS = Properties.RESET_STATIC_FIELDS;
    private final boolean DEFAULT_JUNIT_CHECK = Properties.JUNIT_CHECK;
    private final boolean DEFAULT_JUNIT_TESTS = Properties.JUNIT_TESTS;
    private final boolean DEFAULT_PURE_INSPECTORS = Properties.PURE_INSPECTORS;
    private final boolean DEFAULT_SANDBOX = Properties.SANDBOX;

    @Before
    public void saveProperties() {
        Properties.SANDBOX = true;
        Properties.RESET_STATIC_FIELDS = true;
        Properties.JUNIT_CHECK = true;
        Properties.JUNIT_TESTS = true;
        Properties.PURE_INSPECTORS = true;
    }

    @After
    public void restoreProperties() {
        Properties.RESET_STATIC_FIELDS = this.DEFAULT_RESET_STATIC_FIELDS;
        Properties.JUNIT_CHECK = this.DEFAULT_JUNIT_CHECK;
        Properties.JUNIT_TESTS = this.DEFAULT_JUNIT_TESTS;
        Properties.PURE_INSPECTORS = this.DEFAULT_PURE_INSPECTORS;
        Properties.SANDBOX = this.DEFAULT_SANDBOX;
    }

    @Test
    public void test() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ImpureInspector.class.getCanonicalName();
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.HadUnstableTests;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        double best_fitness = best.getFitness();
        Assert.assertTrue((String)"Optimal coverage was not achieved ", (best_fitness == 0.0 ? 1 : 0) != 0);
        CheapPurityAnalyzer purityAnalyzer = CheapPurityAnalyzer.getInstance();
        String descriptor = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
        boolean recursivePureFunction = purityAnalyzer.isPure(targetClass, "recursivePureFunction", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
        Assert.assertTrue((boolean)recursivePureFunction);
        boolean getImpureValue = purityAnalyzer.isPure(targetClass, "getImpureValue", descriptor);
        Assert.assertFalse((boolean)getImpureValue);
        boolean getPureValue = purityAnalyzer.isPure(targetClass, "getPureValue", descriptor);
        Assert.assertTrue((boolean)getPureValue);
        boolean getImpureValueFromCall = purityAnalyzer.isPure(targetClass, "getImpureValueFromCall", descriptor);
        Assert.assertFalse((boolean)getImpureValueFromCall);
        boolean getPureValueFromCall = purityAnalyzer.isPure(targetClass, "getPureValueFromCall", descriptor);
        Assert.assertTrue((boolean)getPureValueFromCall);
        boolean recursivePureInspector = purityAnalyzer.isPure(targetClass, "recursivePureInspector", descriptor);
        Assert.assertTrue((boolean)recursivePureInspector);
        boolean recursiveImpureInspector = purityAnalyzer.isPure(targetClass, "recursiveImpureInspector", descriptor);
        Assert.assertFalse((boolean)recursiveImpureInspector);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable unstable = (OutputVariable)map.get(RuntimeVariable.HadUnstableTests.toString());
        Assert.assertNotNull((Object)unstable);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)unstable.getValue());
    }
}

